/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.Logger;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDMultiPageEditorPart;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphViewer;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDTabbedPropertySheetPage;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAdapterFactoryLabelProvider;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.wst.xsd.ui.internal.util.OpenOnSelectionHelper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XSDEditor
extends XSDMultiPageEditorPart
implements ITabbedPropertySheetPageContributor {
    protected StructuredTextEditor textEditor;
    IFile resourceFile;
    XSDSelectionManager xsdSelectionManager;
    XSDModelAdapter schemalNodeAdapter;
    private IStructuredModel result;
    InternalPartListener partListener = new InternalPartListener(this);
    protected CommandStackListener commandStackListener;
    protected IPropertyChangeListener preferenceStoreListener = new PreferenceStoreListener();
    int currentPage = -1;
    protected OpenOnSelectionHelper openOnSelectionHelper;
    int sourcePageIndex = -1;
    int graphPageIndex = -1;
    XSDGraphViewer graphViewer;
    protected XSDModelAdapterFactoryImpl xsdModelAdapterFactory;
    protected XSDAdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private IPropertySheetPage fPropertySheetPage;
    private IContentOutlinePage fOutlinePage;
    private OutlineTreeSelectionChangeListener fOutlineListener;
    private SourceEditorSelectionListener fSourceEditorSelectionListener;
    private XSDSelectionManagerSelectionListener fXSDSelectionListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public XSDEditor() {
        this.xsdSelectionManager = new XSDSelectionManager();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dw.getActivePage();
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        try {
            if (page != null) {
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException partInitException) {}
    }

    protected void createPages() {
        try {
            if (!this.loadFile()) {
                return;
            }
            this.xsdModelAdapterFactory = XSDModelAdapterFactoryImpl.getInstance();
            this.adapterFactoryLabelProvider = new XSDAdapterFactoryLabelProvider(this.xsdModelAdapterFactory);
            this.createSourcePage();
            this.addSourcePage();
            this.buildXSDModel();
            this.createAndAddGraphPage();
            int pageIndexToShow = this.getDefaultPageTypeIndex();
            this.setActivePage(pageIndexToShow);
            this.openOnSelectionHelper = new OpenOnSelectionHelper(this.textEditor, this.getXSDSchema());
            ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
            this.fSourceEditorSelectionListener = new SourceEditorSelectionListener();
            if (provider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
            } else {
                provider.addSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
            }
            this.fXSDSelectionListener = new XSDSelectionManagerSelectionListener();
            this.getSelectionManager().addSelectionChangedListener(this.fXSDSelectionListener);
            this.addCommandStackListener();
            XSDEditorPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(this.preferenceStoreListener);
        }
        catch (PartInitException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public void buildXSDModel() {
        block7: {
            try {
                boolean schemaNodeExists;
                IDOMDocument document = ((IDOMModel)this.getModel()).getDocument();
                boolean bl = schemaNodeExists = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema").getLength() == 1;
                if (document.getChildNodes().getLength() == 0 || !schemaNodeExists) {
                    this.createDefaultSchemaNode((Document)document);
                }
                if (!(document instanceof INodeNotifier)) break block7;
                INodeNotifier notifier = (INodeNotifier)document;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.schemalNodeAdapter = (XSDModelAdapter)notifier.getAdapterFor((Object)clazz);
                if (this.schemalNodeAdapter == null) {
                    this.schemalNodeAdapter = new XSDModelAdapter();
                    notifier.addAdapter((INodeAdapter)this.schemalNodeAdapter);
                    this.schemalNodeAdapter.createSchema(document.getDocumentElement());
                }
            }
            catch (Exception exception) {}
        }
    }

    public String[] getPropertyCategories() {
        return new String[]{"general", "namespace", "other", "attributes", "documentation", "facets"};
    }

    public String getContributorId() {
        return "org.eclipse.wst.xsd.ui.internal.XSDEditor";
    }

    protected void addCommandStackListener() {
        if (this.commandStackListener == null) {
            this.getModel().getUndoManager();
            this.commandStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject event) {
                    Object obj = event.getSource();
                    if (obj instanceof BasicCommandStack) {
                        BasicCommandStack stack = (BasicCommandStack)obj;
                        Command recentCommand = stack.getMostRecentCommand();
                        Command redoCommand = stack.getRedoCommand();
                        stack.getUndoCommand();
                        if (recentCommand == redoCommand) {
                            XSDEditor.this.resetInformationTasks();
                        }
                    }
                }
            };
        }
    }

    protected void pageChange(int arg) {
        super.pageChange(arg);
    }

    protected void removeCommandStackListener() {
        if (this.commandStackListener != null) {
            this.getModel().getUndoManager();
        }
    }

    protected int getDefaultPageTypeIndex() {
        int pageIndex = this.sourcePageIndex;
        if (XSDEditorPlugin.getPlugin().getDefaultPage().equals(XSDEditorPlugin.GRAPH_PAGE) && this.graphPageIndex != -1) {
            pageIndex = this.graphPageIndex;
        }
        return pageIndex;
    }

    public String getCurrentPageType() {
        if (this.getActivePage() != -1) {
            this.currentPage = this.getActivePage();
        }
        if (this.currentPage == this.graphPageIndex) {
            return XSDEditorPlugin.GRAPH_PAGE;
        }
        return XSDEditorPlugin.SOURCE_PAGE;
    }

    public Object getActivePart() {
        return this.getSite().getWorkbenchWindow().getActivePage().getActivePart();
    }

    public void dispose() {
        ISelectionProvider provider;
        if (this.fOutlinePage != null) {
            if (this.fOutlinePage instanceof ConfigurableContentOutlinePage && this.fOutlineListener != null) {
                ((ConfigurableContentOutlinePage)this.fOutlinePage).removeDoubleClickListener((IDoubleClickListener)this.fOutlineListener);
            }
            if (this.fOutlineListener != null) {
                this.fOutlinePage.removeSelectionChangedListener((ISelectionChangedListener)this.fOutlineListener);
            }
        }
        if ((provider = this.getTextEditor().getSelectionProvider()) instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).removePostSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        } else {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        }
        this.getSelectionManager().removeSelectionChangedListener(this.fXSDSelectionListener);
        this.removeCommandStackListener();
        XSDEditorPlugin.getPlugin().setDefaultPage(this.getCurrentPageType());
        XSDEditorPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(this.preferenceStoreListener);
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
        IStructuredModel myModel = this.textEditor.getModel();
        if (myModel != null && myModel instanceof IStructuredDocumentListener) {
            myModel.getStructuredDocument().removeDocumentChangingListener((IStructuredDocumentListener)myModel);
        }
        this.textEditor = null;
        this.resourceFile = null;
        this.xsdSelectionManager = null;
        this.schemalNodeAdapter = null;
        this.result = null;
        this.partListener = null;
        this.commandStackListener = null;
        this.preferenceStoreListener = null;
        this.openOnSelectionHelper = null;
        this.graphViewer = null;
        super.dispose();
        if (this.schemalNodeAdapter != null) {
            this.schemalNodeAdapter.clear();
            this.schemalNodeAdapter = null;
        }
    }

    protected boolean loadFile() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            if (input instanceof ILocationProvider) {
                IPath path = ((ILocationProvider)input).getPath((Object)input);
                String ext = path.getFileExtension();
                return ext != null && ext.equals("xsd");
            }
            return false;
        }
        this.resourceFile = ((IFileEditorInput)input).getFile();
        return true;
    }

    public void openOnGlobalReference(XSDConcreteComponent comp) {
        this.openOnSelectionHelper.openOnGlobalReference(comp);
    }

    public OpenOnSelectionHelper getOpenOnSelectionHelper() {
        return this.openOnSelectionHelper;
    }

    protected StructuredTextEditor createTextEditor() {
        this.textEditor = new StructuredTextEditor();
        return this.textEditor;
    }

    protected void createSourcePage() throws PartInitException {
        super.createSourcePage();
    }

    protected void addSourcePage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
        this.setPageText(this.sourcePageIndex, XSDEditorPlugin.getXSDString("_UI_TAB_SOURCE"));
        this.textEditor.update();
        this.firePropertyChange(1);
    }

    protected void createAndAddGraphPage() throws PartInitException {
        this.graphViewer = new XSDGraphViewer(this);
        this.graphViewer.setSchema(this.getXSDSchema());
        Control graphControl = this.graphViewer.createControl(this.getContainer());
        this.graphPageIndex = this.addPage(graphControl);
        this.setPageText(this.graphPageIndex, XSDEditorPlugin.getXSDString("_UI_TAB_GRAPH"));
        this.graphViewer.setSelectionManager(this.getSelectionManager());
        if (this.getXSDSchema() != null) {
            this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.getXSDSchema()));
        }
    }

    public Object getAdapter(Class key) {
        Class<?> clazz;
        Object result = null;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            result = this.xsdSelectionManager;
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(key)) {
            this.fPropertySheetPage = new XSDTabbedPropertySheetPage(this);
            ((XSDTabbedPropertySheetPage)this.fPropertySheetPage).setXSDModelAdapterFactory(this.xsdModelAdapterFactory);
            ((XSDTabbedPropertySheetPage)this.fPropertySheetPage).setSelectionManager(this.getSelectionManager());
            ((XSDTabbedPropertySheetPage)this.fPropertySheetPage).setXSDSchema(this.getXSDSchema());
            return this.fPropertySheetPage;
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(key)) {
            if (this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) {
                IContentOutlinePage page = (IContentOutlinePage)super.getAdapter(key);
                if (page != null) {
                    this.fOutlineListener = new OutlineTreeSelectionChangeListener();
                    page.addSelectionChangedListener((ISelectionChangedListener)this.fOutlineListener);
                    if (page instanceof ConfigurableContentOutlinePage) {
                        ((ConfigurableContentOutlinePage)page).addDoubleClickListener((IDoubleClickListener)this.fOutlineListener);
                    }
                }
                this.fOutlinePage = page;
            }
            return this.fOutlinePage;
        }
        result = super.getAdapter(key);
        return result;
    }

    public XSDModelAdapterFactoryImpl getXSDModelAdapterFactory() {
        return this.xsdModelAdapterFactory;
    }

    public XSDAdapterFactoryLabelProvider getLabelProvider() {
        return this.adapterFactoryLabelProvider;
    }

    public XSDSelectionManager getSelectionManager() {
        return this.xsdSelectionManager;
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public void reparseSchema() {
        IDOMDocument document = ((IDOMModel)this.getModel()).getDocument();
        if (this.schemalNodeAdapter != null) {
            this.schemalNodeAdapter.createSchema(document.getDocumentElement());
        }
    }

    public XSDSchema getXSDSchema() {
        return this.schemalNodeAdapter != null ? this.schemalNodeAdapter.getSchema() : null;
    }

    public IFile getFileResource() {
        return this.resourceFile;
    }

    public IDocument getEditorIDocument() {
        IDocument document = this.textEditor.getTextViewer().getDocument();
        return document;
    }

    public void createTasksInTaskList(ArrayList messages) {
    }

    public void resetInformationTasks() {
    }

    public XSDGraphViewer getGraphViewer() {
        return this.graphViewer;
    }

    public IEditorPart getActiveEditorPage() {
        return this.getActiveEditor();
    }

    public StructuredTextEditor getTextEditor() {
        return this.textEditor;
    }

    public void createDefaultSchemaNode(Document document) {
        if (document.getChildNodes().getLength() == 0) {
            String encoding = "UTF-8";
            ProcessingInstruction instr = document.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"" + encoding + "\"");
            document.appendChild(instr);
        }
        String defaultPrefixForTargetNamespace = "tns";
        String prefixForSchemaNamespace = "";
        String schemaNamespaceAttribute = "xmlns";
        if (XSDEditorPlugin.getPlugin().isQualifyXMLSchemaLanguage() && XSDEditorPlugin.getPlugin().getXMLSchemaPrefix().trim().length() > 0) {
            prefixForSchemaNamespace = String.valueOf(XSDEditorPlugin.getPlugin().getXMLSchemaPrefix()) + ":";
            schemaNamespaceAttribute = String.valueOf(schemaNamespaceAttribute) + ":" + XSDEditorPlugin.getPlugin().getXMLSchemaPrefix();
        }
        document.appendChild(document.createTextNode("\n"));
        Element element = document.createElement(String.valueOf(prefixForSchemaNamespace) + "schema");
        element.setAttribute(schemaNamespaceAttribute, "http://www.w3.org/2001/XMLSchema");
        String defaultTargetURI = XSDEditorPlugin.getPlugin().getXMLSchemaTargetNamespace();
        element.setAttribute("targetNamespace", defaultTargetURI);
        element.setAttribute("xmlns:" + defaultPrefixForTargetNamespace, defaultTargetURI);
        document.appendChild(element);
    }

    class OutlineTreeSelectionChangeListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private ISelection getXSDSelection(ISelection selection) {
            IStructuredSelection structuredSelection;
            Object o;
            StructuredSelection sel = null;
            if (selection instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
                sel = new StructuredSelection(o);
            }
            return sel;
        }

        private Object getObjectForOtherModel(Object object) {
            Node node = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof XSDComponent) {
                node = ((XSDComponent)object).getElement();
            } else if (object instanceof CategoryAdapter) {
                node = ((CategoryAdapter)object).getXSDSchema().getElement();
            }
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }

        public void doubleClick(DoubleClickEvent event) {
            if (XSDEditor.this.getSelectionManager() != null && XSDEditor.this.getSelectionManager().enableNotify) {
                ISelection selection = this.getXSDSelection(event.getSelection());
                if (selection != null) {
                    XSDEditor.this.getSelectionManager().setSelection(selection, (ISelectionProvider)XSDEditor.this.fOutlinePage);
                }
                if (XSDEditor.this.getTextEditor() != null && selection instanceof IStructuredSelection) {
                    int start = -1;
                    int length = 0;
                    Object o = ((IStructuredSelection)selection).getFirstElement();
                    if (o != null) {
                        o = this.getObjectForOtherModel(o);
                    }
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o).getEndOffset() - start;
                    }
                    if (start > -1) {
                        XSDEditor.this.getTextEditor().selectAndReveal(start, length);
                    }
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (XSDEditor.this.getSelectionManager() != null && (selection = this.getXSDSelection(event.getSelection())) != null) {
                XSDEditor.this.getSelectionManager().setSelection(selection, (ISelectionProvider)XSDEditor.this.fOutlinePage);
            }
        }
    }

    private class SourceEditorSelectionListener
    implements ISelectionChangedListener {
        SourceEditorSelectionListener() {
        }

        private Object getXSDNode(Object object) {
            XSDConcreteComponent modelObject;
            Node node;
            Element element = null;
            if (object instanceof Node && (node = (Node)object) != null) {
                if (node.getNodeType() == 1) {
                    element = (Element)node;
                } else if (node.getNodeType() == 2) {
                    element = ((Attr)node).getOwnerElement();
                }
            }
            Element o = element;
            if (element != null && (modelObject = XSDEditor.this.getXSDSchema().getCorrespondingComponent(element)) != null) {
                o = modelObject;
            }
            return o;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                ArrayList<Object> xsdSelections = new ArrayList<Object>();
                Iterator i = ((IStructuredSelection)selection).iterator();
                while (i.hasNext()) {
                    Object domNode = i.next();
                    Object xsdNode = this.getXSDNode(domNode);
                    if (xsdNode == null) continue;
                    xsdSelections.add(xsdNode);
                }
                if (!xsdSelections.isEmpty()) {
                    StructuredSelection xsdSelection = new StructuredSelection(xsdSelections);
                    XSDEditor.this.getSelectionManager().setSelection((ISelection)xsdSelection, XSDEditor.this.getTextEditor().getSelectionProvider());
                }
            }
        }
    }

    private class XSDSelectionManagerSelectionListener
    implements ISelectionChangedListener {
        XSDSelectionManagerSelectionListener() {
        }

        private Object getObjectForOtherModel(Object object) {
            Node node = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof XSDComponent) {
                node = ((XSDComponent)object).getElement();
            } else if (object instanceof CategoryAdapter) {
                node = ((CategoryAdapter)object).getXSDSchema().getElement();
            }
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (event.getSource() != XSDEditor.this.getTextEditor().getSelectionProvider() && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> otherModelObjectList = new ArrayList<Object>();
                Iterator i = ((IStructuredSelection)selection).iterator();
                while (i.hasNext()) {
                    Object modelObject = i.next();
                    Object otherModelObject = this.getObjectForOtherModel(modelObject);
                    if (otherModelObject == null) continue;
                    otherModelObjectList.add(otherModelObject);
                }
                if (!otherModelObjectList.isEmpty()) {
                    StructuredSelection nodeSelection = new StructuredSelection(otherModelObjectList);
                    XSDEditor.this.getTextEditor().getSelectionProvider().setSelection((ISelection)nodeSelection);
                }
            }
        }
    }

    private class PreferenceStoreListener
    implements IPropertyChangeListener {
        PreferenceStoreListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    class InternalPartListener
    implements IPartListener {
        XSDEditor editor;

        public InternalPartListener(XSDEditor editor) {
            this.editor = editor;
        }

        public void partActivated(IWorkbenchPart part) {
            ISelection selection;
            if (part == this.editor && (selection = XSDEditor.this.getSelectionManager().getSelection()) != null) {
                if (XSDEditor.this.getCurrentPageType().equals(XSDEditorPlugin.GRAPH_PAGE)) {
                    XSDEditor.this.getSelectionManager().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.editor.getGraphViewer().getComponentViewer(), selection));
                } else if (XSDEditor.this.getCurrentPageType().equals(XSDEditorPlugin.SOURCE_PAGE)) {
                    XSDEditor.this.getSelectionManager().setSelection(selection);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

