/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.BaseGlobalCleanup;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.GlobalAttributeCleanup;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.GlobalAttributeGroupCleanup;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.GlobalElementCleanup;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.GlobalGroupCleanup;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.GlobalSimpleOrComplexTypeCleanup;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.XSDExternalFileCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Node;

public class DeleteAction
extends SelectionListenerAction {
    protected IEditorPart editor;
    protected XSDSchema xsdSchema;
    protected ISelectionProvider selectionProvider;
    protected XSDConcreteComponent parentXSDComponent;

    public DeleteAction(String text, IEditorPart editor, XSDSchema xsdSchema) {
        super(text);
        this.editor = editor;
        this.xsdSchema = xsdSchema;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public XSDSchema getSchema() {
        return this.xsdSchema;
    }

    public void setXSDSchema(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Iterator iter = selection.iterator();
        DocumentImpl doc = null;
        while (iter.hasNext()) {
            Object obj = iter.next();
            Node node = null;
            if (obj instanceof Node) {
                node = (Node)obj;
            } else if (obj instanceof XSDConcreteComponent) {
                this.xsdSchema = ((XSDConcreteComponent)obj).getSchema();
                node = ((XSDConcreteComponent)obj).getElement();
                if (node instanceof IDOMNode) {
                    this.parentXSDComponent = ((XSDConcreteComponent)obj).getContainer();
                    if (this.parentXSDComponent instanceof XSDParticle) {
                        this.parentXSDComponent = this.parentXSDComponent.getContainer();
                    }
                }
            }
            if (XSDDOMHelper.inputEquals(node, "schema", false) || !(node instanceof IDOMNode)) continue;
            if (doc == null) {
                doc = (DocumentImpl)node.getOwnerDocument();
                doc.getModel().beginRecording((Object)this, XSDEditorPlugin.getXSDString("_UI_ACTION_DELETE_NODES"));
            }
            boolean refresh = this.cleanupReferences(node);
            if (node == null) continue;
            XSDDOMHelper.removeNodeAndWhitespace(node);
        }
        if (this.parentXSDComponent != null && this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.parentXSDComponent));
        }
        if (doc != null) {
            doc.getModel().endRecording((Object)this);
        }
    }

    protected boolean cleanupReferences(Node deletedNode) {
        boolean refresh = false;
        XSDConcreteComponent comp = this.getSchema().getCorrespondingComponent(deletedNode);
        if (comp instanceof XSDInclude || comp instanceof XSDImport || comp instanceof XSDRedefine) {
            XSDSchema referencedSchema = null;
            if (comp instanceof XSDInclude) {
                referencedSchema = ((XSDInclude)comp).getIncorporatedSchema();
                refresh = true;
            } else if (comp instanceof XSDRedefine) {
                referencedSchema = ((XSDRedefine)comp).getIncorporatedSchema();
                refresh = true;
            } else if (comp instanceof XSDImport) {
                referencedSchema = ((XSDImport)comp).getResolvedSchema();
                refresh = true;
            }
            if (referencedSchema != null) {
                XSDExternalFileCleanup cleanHelper = new XSDExternalFileCleanup(referencedSchema);
                cleanHelper.visitSchema(this.getSchema());
            }
            if (comp instanceof XSDImport) {
                TypesHelper typesHelper = new TypesHelper(this.getSchema());
                typesHelper.updateMapAfterDelete((XSDImport)comp);
            }
        } else if (this.getSchema().equals(comp.getContainer())) {
            BaseGlobalCleanup cleanHelper = null;
            if (comp instanceof XSDElementDeclaration) {
                cleanHelper = new GlobalElementCleanup(comp);
            } else if (comp instanceof XSDModelGroupDefinition) {
                cleanHelper = new GlobalGroupCleanup(comp);
            } else if (comp instanceof XSDTypeDefinition) {
                cleanHelper = new GlobalSimpleOrComplexTypeCleanup(comp);
            } else if (comp instanceof XSDAttributeDeclaration) {
                cleanHelper = new GlobalAttributeCleanup(comp);
            } else if (comp instanceof XSDAttributeGroupDefinition) {
                cleanHelper = new GlobalAttributeGroupCleanup(comp);
            }
            if (cleanHelper != null) {
                cleanHelper.visitSchema(this.getSchema());
            }
        }
        return refresh;
    }
}

