/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.graph.BaseGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.graph.LinkedGraphViewer;
import org.eclipse.wst.xsd.ui.internal.graph.PrintGraphAction;
import org.eclipse.wst.xsd.ui.internal.graph.XSDComponentViewer;
import org.eclipse.wst.xsd.ui.internal.graph.XSDInheritanceViewer;
import org.eclipse.wst.xsd.ui.internal.graph.XSDSubstitutionGroupsViewer;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.TopLevelComponentEditPart;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XSDGraphViewer
implements ISelectionChangedListener {
    protected PageBook pageBook;
    protected Control componentViewerControl;
    protected Control inheritanceViewerControl;
    protected Control subGroupsViewerControl;
    protected XSDComponentViewer componentViewer;
    protected XSDInheritanceViewer inheritanceViewer;
    protected XSDSubstitutionGroupsViewer subGroupsViewer;
    protected XSDSelectionManager xsdSelectionManager;
    protected XSDSchema schema;
    protected InternalSelectionProvider internalSelectionProvider = new InternalSelectionProvider();
    protected XSDEditor editor;
    protected PrintGraphAction printGraphAction;
    protected SashForm sashForm;
    protected ToolItem backButton;
    ToolBar graphToolBar;
    ToolItem toolItem;
    ViewForm form;
    Composite frameBar;
    Composite c;
    LinkedGraphViewer linkInheritanceViewer;
    LinkedGraphViewer linkSubstitutionGroupViewer;
    private static Color dividerColor;

    public XSDGraphViewer(XSDEditor editor) {
        this.editor = editor;
    }

    public void setSchema(XSDSchema schema) {
        this.schema = schema;
    }

    protected void createInheritanceViewer(Composite parent) {
        this.linkInheritanceViewer = new LinkedGraphViewer(this.editor, this.internalSelectionProvider);
        BaseGraphicalViewer graphViewer = new XSDInheritanceViewer(this.editor, this.internalSelectionProvider);
        this.linkInheritanceViewer.setMajorViewer(graphViewer);
        graphViewer = new XSDComponentViewer(this.editor, this.editor.getSelectionManager());
        this.linkInheritanceViewer.setMinorViewer(graphViewer);
        this.linkInheritanceViewer.createControl(parent);
    }

    protected void createSubstitutionGroupViewer(Composite parent) {
        this.linkSubstitutionGroupViewer = new LinkedGraphViewer(this.editor, this.internalSelectionProvider);
        BaseGraphicalViewer graphViewer = new XSDSubstitutionGroupsViewer(this.editor, this.internalSelectionProvider);
        this.linkSubstitutionGroupViewer.setMajorViewer(graphViewer);
        graphViewer = new XSDComponentViewer(this.editor, this.internalSelectionProvider);
        this.linkSubstitutionGroupViewer.setMinorViewer(graphViewer);
        this.linkSubstitutionGroupViewer.createControl(parent);
    }

    public Control createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.componentViewer = new XSDComponentViewer(this.editor, this.editor.getSelectionManager());
        this.form = new ViewForm((Composite)this.pageBook, 0);
        this.frameBar = new Composite((Composite)this.form, 0);
        GridLayout frameLayout = new GridLayout();
        frameLayout.marginWidth = 0;
        frameLayout.marginHeight = 0;
        this.frameBar.setLayout((Layout)frameLayout);
        this.graphToolBar = new ToolBar(this.frameBar, 0x800000);
        this.graphToolBar.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128) {
                    e.doit = false;
                }
            }
        });
        this.backButton = new ToolItem(this.graphToolBar, 8);
        this.backButton.setImage(XSDEditorPlugin.getXSDImage("icons/back.gif"));
        this.backButton.setToolTipText(XSDEditorPlugin.getXSDString("_UI_HOVER_BACK_TO_SCHEMA_VIEW"));
        this.backButton.setEnabled(false);
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSDGraphViewer.this.editor.getGraphViewer().setInput(XSDGraphViewer.this.editor.getXSDSchema());
                XSDGraphViewer.this.editor.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)XSDGraphViewer.this.editor.getXSDSchema()));
            }
        });
        this.form.setTopLeft((Control)this.frameBar);
        this.componentViewerControl = this.componentViewer.createControl((Composite)this.form);
        this.c = ViewUtility.createComposite((Composite)this.form, 1);
        this.form.setContent(this.componentViewerControl);
        this.form.setData("layout ratio", (Object)new Float(0.65));
        if (dividerColor == null) {
            dividerColor = new Color((Device)this.componentViewerControl.getDisplay(), 143, 141, 138);
        }
        this.pageBook.showPage((Control)this.form);
        this.componentViewer.addSelectionChangedListener(this.internalSelectionProvider);
        this.printGraphAction = new PrintGraphAction(this.componentViewer);
        return this.pageBook;
    }

    public Action getPrintGraphAction() {
        return this.printGraphAction;
    }

    public void updateDesignLayout(int newLayout) {
        this.sashForm.setOrientation(newLayout);
        this.sashForm.layout();
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    public void enableDesignView(boolean enable) {
    }

    public XSDComponentViewer getComponentViewer() {
        return this.componentViewer;
    }

    public void setBackButtonEnabled(boolean state) {
        this.backButton.setEnabled(state);
    }

    public void setInput(Object object) {
        if (object instanceof XSDConcreteComponent) {
            XSDConcreteComponent xsdComp = (XSDConcreteComponent)object;
            if (xsdComp instanceof XSDSchema) {
                this.setBackButtonEnabled(false);
            } else {
                this.setBackButtonEnabled(true);
            }
            this.componentViewer.setInput(xsdComp);
            this.componentViewer.setSelection(xsdComp);
        }
    }

    protected boolean isDeleted(XSDConcreteComponent component) {
        boolean result = false;
        if (component != null && component.getElement() != null) {
            result = component.getElement().getParentNode() == null;
        }
        return result;
    }

    public void setSelectionManager(XSDSelectionManager newSelectionManager) {
        if (this.xsdSelectionManager != null) {
            this.xsdSelectionManager.removeSelectionChangedListener(this);
            this.internalSelectionProvider.removeSelectionChangedListener(this.xsdSelectionManager);
        }
        this.xsdSelectionManager = newSelectionManager;
        if (this.xsdSelectionManager != null) {
            this.xsdSelectionManager.addSelectionChangedListener(this);
            this.internalSelectionProvider.addSelectionChangedListener(this.xsdSelectionManager);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() != this.getComponentViewer()) {
            this.handleSelection(event, true);
        }
    }

    protected XSDConcreteComponent getTopLevelComponent(XSDConcreteComponent component) {
        XSDConcreteComponent prev = component;
        XSDConcreteComponent container = component;
        while (container != null && !(container instanceof XSDSchema)) {
            prev = container;
            container = container.getContainer();
        }
        return container != null ? prev : null;
    }

    protected void handleSelection(SelectionChangedEvent event, boolean isSelectionRequired) {
        StructuredSelection s = (StructuredSelection)event.getSelection();
        Object obj = s.getFirstElement();
        if (obj instanceof XSDConcreteComponent) {
            EditPart editPart;
            XSDConcreteComponent selectedComponent = (XSDConcreteComponent)obj;
            XSDConcreteComponent currentInput = this.getComponentViewer().getInput();
            XSDSchema topLevelSchema = null;
            if (currentInput instanceof XSDSchema && (selectedComponent instanceof XSDSchema || selectedComponent.getContainer() instanceof XSDSchema)) {
                topLevelSchema = (XSDSchema)currentInput;
            }
            if (selectedComponent instanceof XSDSchemaDirective || selectedComponent instanceof XSDNotationDeclaration) {
                topLevelSchema = selectedComponent.getSchema();
            } else if (selectedComponent instanceof XSDAttributeGroupContent || selectedComponent instanceof XSDWildcard) {
                if (selectedComponent.getContainer() instanceof XSDAttributeGroupDefinition) {
                    topLevelSchema = selectedComponent.getSchema();
                }
            } else if (selectedComponent instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)selectedComponent;
                EditPart editPart2 = this.componentViewer.getEditPart((EditPart)this.componentViewer.getRootEditPart(), st);
                if (editPart2 == null && st.getContainer() == this.editor.getXSDSchema()) {
                    topLevelSchema = selectedComponent.getSchema();
                }
            }
            if (topLevelSchema != null) {
                this.setInput(topLevelSchema);
            } else {
                XSDConcreteComponent topLevelComponent;
                editPart = this.getComponentViewer().getEditPart((EditPart)this.getComponentViewer().getRootEditPart(), obj);
                if (editPart == null && (topLevelComponent = this.getTopLevelComponent(selectedComponent)) != null) {
                    this.setInput(topLevelComponent);
                }
            }
            if (isSelectionRequired) {
                editPart = this.getComponentViewer().getRootEditPart();
                EditPart newSelectedEditPart = this.getComponentViewer().getEditPart(editPart, obj);
                if (newSelectedEditPart != null) {
                    if (newSelectedEditPart instanceof TopLevelComponentEditPart) {
                        ((TopLevelComponentEditPart)newSelectedEditPart).setScroll(true);
                    }
                    this.getComponentViewer().setSelection((ISelection)new StructuredSelection((Object)newSelectedEditPart));
                }
            }
        } else if (obj instanceof CategoryAdapter) {
            this.setInput(((CategoryAdapter)obj).getXSDSchema());
        }
    }

    protected Element getElementNode(Node node) {
        while (!(node instanceof Element)) {
            if (node instanceof Attr) {
                node = ((Attr)node).getOwnerElement();
                continue;
            }
            if (node instanceof Text) {
                Node sibling = node.getNextSibling();
                if (sibling == null) break;
                node = sibling;
                continue;
            }
            Node parent = node.getParentNode();
            if (parent == null) break;
            node = node.getParentNode();
        }
        return node instanceof Element ? (Element)node : null;
    }

    class InternalSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        protected List listenerList = new ArrayList();
        protected ISelection selection = new StructuredSelection();

        InternalSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listenerList.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listenerList.remove(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        protected void notifyListeners(SelectionChangedEvent event) {
            Iterator i = this.listenerList.iterator();
            while (i.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)i.next();
                listener.selectionChanged(event);
            }
        }

        public StructuredSelection convertSelectionFromEditPartToModel(ISelection editPartSelection) {
            ArrayList<Object> selectedModelObjectList = new ArrayList<Object>();
            if (editPartSelection instanceof IStructuredSelection) {
                Iterator i = ((IStructuredSelection)editPartSelection).iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    Object model = null;
                    if (obj instanceof EditPart) {
                        EditPart editPart = (EditPart)obj;
                        model = editPart.getModel();
                    } else if (obj instanceof XSDConcreteComponent) {
                        model = obj;
                    }
                    if (model == null) continue;
                    selectedModelObjectList.add(model);
                }
            }
            return new StructuredSelection(selectedModelObjectList);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection newSelection = this.convertSelectionFromEditPartToModel(event.getSelection());
            this.selection = newSelection;
            SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)XSDGraphViewer.this.getComponentViewer(), (ISelection)newSelection);
            this.notifyListeners(newEvent);
        }
    }
}

