/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editpolicies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.actions.MoveAction;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IConnectionRenderingViewer;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ComplexTypeDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.GraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ModelGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ModelGroupEditPart;
import org.eclipse.xsd.XSDConcreteComponent;

public class DragAndDropCommand
extends Command {
    protected EditPartViewer viewer;
    protected ChangeBoundsRequest request;
    protected GraphNodeEditPart childRefEditPart;
    public GraphNodeEditPart parentEditPart;
    public Point location;
    protected MoveAction action;
    protected boolean canExecute;

    public DragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request) {
        List list;
        this.viewer = viewer;
        this.request = request;
        this.location = request.getLocation();
        EditPart target = viewer.findObjectAt(this.location);
        if (viewer instanceof ScrollingGraphicalViewer) {
            ScrollingGraphicalViewer sgv = (ScrollingGraphicalViewer)viewer;
            Point p = ((FigureCanvas)sgv.getControl()).getViewport().getViewLocation();
            this.location.y += p.y;
            this.location.x += p.x;
        }
        if ((list = request.getEditParts()).size() > 0) {
            this.parentEditPart = this.getParentEditPart(target);
            if (this.parentEditPart != null) {
                Iterator i = this.parentEditPart.getChildren().iterator();
                while (i.hasNext()) {
                    EditPart child = (EditPart)i.next();
                    if (!(child instanceof GraphNodeEditPart)) continue;
                    GraphNodeEditPart childGraphNodeEditPart = (GraphNodeEditPart)child;
                    Rectangle rectangle = childGraphNodeEditPart.getSelectionFigure().getBounds();
                    if (this.location.y >= rectangle.getCenter().y) continue;
                    this.childRefEditPart = childGraphNodeEditPart;
                    break;
                }
                List editPartsList = request.getEditParts();
                ArrayList<XSDConcreteComponent> concreteComponentList = new ArrayList<XSDConcreteComponent>(editPartsList.size());
                Iterator i2 = editPartsList.iterator();
                while (i2.hasNext()) {
                    EditPart editPart = (EditPart)i2.next();
                    concreteComponentList.add((XSDConcreteComponent)editPart.getModel());
                }
                XSDConcreteComponent refComponent = this.childRefEditPart != null ? (XSDConcreteComponent)this.childRefEditPart.getModel() : null;
                this.action = new MoveAction((XSDConcreteComponent)this.parentEditPart.getModel(), concreteComponentList, refComponent);
                this.canExecute = this.action.canMove();
            }
        }
    }

    protected GraphNodeEditPart getParentEditPart(EditPart target) {
        GraphNodeEditPart result = null;
        while (target != null) {
            if (target instanceof ModelGroupEditPart) {
                result = (GraphNodeEditPart)target;
                break;
            }
            if (target instanceof ComplexTypeDefinitionEditPart || target instanceof ModelGroupDefinitionEditPart) {
                List list = target.getChildren();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof ModelGroupEditPart)) continue;
                    result = (GraphNodeEditPart)child;
                    break;
                }
                if (result != null) break;
            }
            target = target.getParent();
        }
        return result;
    }

    public void execute() {
        if (this.canExecute) {
            this.action.run();
        }
    }

    public void redo() {
    }

    public void undo() {
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    public PointList getConnectionPoints(Rectangle draggedFigureBounds) {
        PointList pointList = null;
        if (this.parentEditPart != null && this.childRefEditPart != null && this.viewer instanceof IConnectionRenderingViewer) {
            pointList = ((IConnectionRenderingViewer)this.viewer).getConnectionRenderingFigure().getConnectionPoints((GraphicalEditPart)this.parentEditPart, (GraphicalEditPart)this.childRefEditPart, draggedFigureBounds);
        }
        return pointList != null ? pointList : new PointList();
    }
}

