/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.SchemaDirectiveHelperPropertySource;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.XSDExternalFileCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImportPropertySource
extends SchemaDirectiveHelperPropertySource
implements IPropertySource {
    boolean isSetNamespace = false;

    public ImportPropertySource(Viewer viewer, XSDSchema xsdSchema, IFile currentIFile) {
        super(viewer, xsdSchema, false);
        this.currentIFile = currentIFile;
    }

    public ImportPropertySource(XSDSchema xsdSchema, IFile currentIFile) {
        super(xsdSchema, false);
        this.currentIFile = currentIFile;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        TextPropertyDescriptor prefixDescriptor;
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        SchemaDirectiveHelperPropertySource.SchemaLocationPropertyDescriptor schemaLocationDescriptor = new SchemaDirectiveHelperPropertySource.SchemaLocationPropertyDescriptor(this, "schemaLocation", "schemaLocation");
        schemaLocationDescriptor.setHelpContextIds("org.eclipse.wst.xsd.ui.internal.xsde2100");
        list.add(schemaLocationDescriptor);
        if (this.isSetNamespace) {
            prefixDescriptor = new TextPropertyDescriptor((Object)"Prefix", "Prefix");
            prefixDescriptor.setHelpContextIds((Object)"org.eclipse.wst.xsd.ui.internal.xsde2210");
            list.add((PropertyDescriptor)prefixDescriptor);
        } else {
            prefixDescriptor = new PropertyDescriptor((Object)"Prefix", "Prefix");
            prefixDescriptor.setHelpContextIds((Object)"org.eclipse.wst.xsd.ui.internal.xsde2210");
            list.add((PropertyDescriptor)prefixDescriptor);
        }
        PropertyDescriptor namespaceDescriptor = new PropertyDescriptor((Object)"namespace", "namespace");
        list.add(namespaceDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            String attributeName = (String)id;
            if (result == null) {
                result = "";
            }
            if (attributeName.equals("Prefix")) {
                TypesHelper helper = new TypesHelper(this.xsdSchema);
                String aPrefix = helper.getPrefix(this.element.getAttribute("namespace"), false);
                if (aPrefix != null && aPrefix.length() > 0) {
                    return aPrefix;
                }
                return "";
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
            String namespace = this.element.getAttribute("namespace");
            String oldPrefixValue = typesHelper.getPrefix(namespace, false);
            String schemaLocation = this.element.getAttribute("schemaLocation");
            if (((String)id).equals("Prefix")) {
                Map map;
                if (this.validatePrefix(newValue) && schemaLocation.length() > 0 && !(map = this.xsdSchema.getQNamePrefixToNamespaceMap()).containsKey(newValue)) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PREFIX_CHANGE"), this.element);
                    map.remove(oldPrefixValue);
                    map.put(newValue, namespace);
                    XSDSchemaHelper.updateElement((XSDConcreteComponent)this.xsdSchema);
                    this.endRecording(this.element);
                }
            } else if (((String)id).equals("schemaLocation")) {
                this.updateExternalModel((String)value, this.selectedIFile, this.selectedNamespace, this.selectedXSDSchema);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (ImportPropertySource.this.viewer != null) {
                    ImportPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    public void setInput(Element element) {
        this.element = element;
        String namespace = element.getAttribute("namespace");
        if (namespace != null && namespace.trim().length() > 0) {
            this.isSetNamespace = true;
        }
    }

    protected void updateExternalModel(String newLocation, IFile newFile, String namespace, XSDSchema externalSchema) {
        XSDConcreteComponent comp;
        if (this.xsdSchema == null) {
            return;
        }
        Element importElement = this.element;
        if (namespace == null) {
            namespace = "";
        }
        if ((comp = this.xsdSchema.getCorrespondingComponent((Node)this.element)) instanceof XSDImport) {
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_IMPORT_CHANGE"), importElement);
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            XSDSchema referencedSchema = ((XSDSchemaDirective)comp).getResolvedSchema();
            if (referencedSchema != null) {
                XSDExternalFileCleanup cleanHelper = new XSDExternalFileCleanup(referencedSchema);
                cleanHelper.visitSchema(this.xsdSchema);
            }
            Element schemaElement = this.xsdSchema.getElement();
            TypesHelper helper = new TypesHelper(externalSchema);
            String prefix = helper.getPrefix(namespace, false);
            boolean prefixAlreadyExists = false;
            if (map.containsKey(prefix)) {
                prefixAlreadyExists = true;
            }
            if (prefix == null || prefix != null && prefix.length() == 0 || prefixAlreadyExists) {
                prefix = "pref";
                int prefixExtension = 1;
                while (map.containsKey(prefix) && prefixExtension < 100) {
                    prefix = String.valueOf(prefix) + String.valueOf(prefixExtension);
                    ++prefixExtension;
                }
            }
            if (namespace.length() > 0) {
                if (map.containsValue(namespace)) {
                    TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
                    prefix = typesHelper.getPrefix(namespace, false);
                } else {
                    schemaElement.setAttribute("xmlns:" + prefix, namespace);
                }
            }
            importElement.setAttribute("schemaLocation", newLocation);
            if (!namespace.equals("")) {
                importElement.setAttribute("namespace", namespace);
            } else {
                importElement.removeAttribute("namespace");
            }
            this.endRecording(importElement);
        }
    }
}

