/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.text.MessageFormat;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.PopupList;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.DynamicCellEditor;

public class XSDComboBoxPropertyDescriptor
extends PropertyDescriptor {
    private String[] values;

    public XSDComboBoxPropertyDescriptor(Object id, String displayName, String[] valuesArray) {
        super(id, displayName);
        this.values = valuesArray;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        XSDComboBoxCellEditor editor = new XSDComboBoxCellEditor(parent, this.values);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public class XSDComboBoxCellEditor
    extends CellEditor {
        DynamicCellEditor comboBox;
        private String fSelection = "";
        protected String[] fItems;
        protected Object fValue;
        int selection;
        Object typeObject;
        private boolean fSettingValue = false;

        public void createItems(String[] items) {
            this.fItems = items;
        }

        public String[] getComboBoxItems() {
            return this.fItems;
        }

        public XSDComboBoxCellEditor(Composite parent, String[] items) {
            super(parent);
            this.setItems(items);
        }

        public void activate() {
            if (this.doGetValue() != null) {
                this.comboBox.setText((String)this.fValue);
            }
        }

        public void deactivate() {
            super.deactivate();
        }

        public void setItems(String[] items) {
            Assert.isNotNull((Object)items);
            this.fItems = items;
            this.populateComboBoxItems();
        }

        private void populateComboBoxItems() {
            if (this.comboBox != null && this.fItems != null) {
                this.comboBox.removeAll();
                int i = 0;
                while (i < this.fItems.length) {
                    this.comboBox.add(this.fItems[i], i);
                    ++i;
                }
                this.setValueValid(true);
                this.selection = 0;
            }
        }

        protected Control createControl(Composite parent) {
            this.comboBox = new DynamicCellEditor(parent, 8);
            this.comboBox.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ XSDComboBoxCellEditor this$1;
                {
                    this.this$1 = xSDComboBoxCellEditor;
                }

                public void keyPressed(KeyEvent e) {
                    this.this$1.keyReleaseOccured(e);
                }
            });
            this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ XSDComboBoxCellEditor this$1;
                {
                    this.this$1 = xSDComboBoxCellEditor;
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }

                public void widgetSelected(SelectionEvent event) {
                    this.this$1.selection = this.this$1.comboBox.getSelectionIndex();
                    if (!this.this$1.comboBox.isDropped()) {
                        this.this$1.applyEditorValueAndDeactivate();
                    }
                }
            });
            this.comboBox.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ XSDComboBoxCellEditor this$1;
                {
                    this.this$1 = xSDComboBoxCellEditor;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.comboBox.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ XSDComboBoxCellEditor this$1;
                {
                    this.this$1 = xSDComboBoxCellEditor;
                }

                public void focusLost(FocusEvent e) {
                    this.this$1.focusLost();
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.setValueValid(true);
            return this.comboBox;
        }

        protected void focusLost() {
            if (this.isActivated()) {
                this.applyEditorValueAndDeactivate();
            }
        }

        protected void keyReleaseOccured(KeyEvent keyEvent) {
            if (keyEvent.character == '\u001b') {
                this.comboBox.setText("");
                this.fireCancelEditor();
            } else if (keyEvent.character == '\r') {
                this.applyEditorValueAndDeactivate();
                this.deactivate();
            }
        }

        void applyEditorValueAndDeactivate() {
            this.selection = this.comboBox.getSelectionIndex();
            if (this.selection < 0) {
                this.deactivate();
                return;
            }
            String newValue = this.fItems[this.selection];
            this.markDirty();
            boolean isValid = this.isCorrect(newValue);
            this.setValueValid(isValid);
            if (!isValid) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.fItems[this.selection]));
            }
            this.doSetValue(newValue);
            this.fireApplyEditorValue();
            this.deactivate();
        }

        protected Object doGetValue() {
            return this.fValue;
        }

        protected void doSetValue(Object value) {
            if (this.fSettingValue) {
                return;
            }
            this.fSettingValue = true;
            if (value instanceof Integer) {
                this.fValue = value;
            } else {
                String stringValue = value.toString();
                int selection = -1;
                int i = 0;
                while (i < this.fItems.length) {
                    if (this.fItems[i].equals(stringValue)) {
                        selection = i;
                    }
                    ++i;
                }
                if (selection >= 0) {
                    this.fValue = stringValue;
                } else {
                    this.fValue = stringValue;
                    if (this.getControl() instanceof CCombo && !stringValue.equals(((CCombo)this.getControl()).getText())) {
                        ((CCombo)this.getControl()).setText(stringValue);
                    }
                }
            }
            this.fSettingValue = false;
        }

        protected void doSetFocus() {
            this.comboBox.setFocus();
        }

        protected void fillPopupList(PopupList list) {
            String[] labels = new String[this.fItems.length];
            int i = 0;
            while (i < labels.length) {
                String item;
                labels[i] = item = this.fItems[i];
                if (this.fSelection == null && this.fValue != null && this.fValue.equals(item)) {
                    this.fSelection = item;
                }
                ++i;
            }
            list.setItems(labels);
            if (this.fSelection != null) {
                list.select(this.fSelection);
            }
        }
    }
}

