/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDWildcard;
import org.w3c.dom.Element;

public class NamespaceProcessContentsSection
extends AbstractSection {
    CCombo namespaceCombo;
    CCombo processContentsCombo;
    private String[] namespaceComboValues = new String[]{"", "##any", "##other", "##targetNamespace", "##local"};

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.namespaceCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.namespaceCombo.setLayoutData((Object)data);
        this.namespaceCombo.setItems(this.namespaceComboValues);
        this.namespaceCombo.addSelectionListener((SelectionListener)this);
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(composite, "namespace");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.namespaceCombo, -5);
        data.top = new FormAttachment((Control)this.namespaceCombo, 0, 0x1000000);
        namespaceLabel.setLayoutData((Object)data);
        this.processContentsCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.namespaceCombo, 4);
        this.processContentsCombo.setLayoutData((Object)data);
        Iterator list = XSDProcessContents.VALUES.iterator();
        this.processContentsCombo.add("");
        while (list.hasNext()) {
            this.processContentsCombo.add(((XSDProcessContents)list.next()).getName());
        }
        this.processContentsCombo.addSelectionListener((SelectionListener)this);
        CLabel processContentsLabel = this.getWidgetFactory().createCLabel(composite, "processContents");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.processContentsCombo, -5);
        data.top = new FormAttachment((Control)this.processContentsCombo, 0, 0x1000000);
        processContentsLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        this.namespaceCombo.setText("");
        this.processContentsCombo.setText("");
        Object input = this.getInput();
        if (input != null && input instanceof XSDWildcard) {
            XSDWildcard wildcard = (XSDWildcard)input;
            if (wildcard.isSetLexicalNamespaceConstraint()) {
                this.namespaceCombo.setText(wildcard.getStringLexicalNamespaceConstraint());
            } else {
                this.namespaceCombo.setText("");
            }
            if (wildcard.isSetProcessContents()) {
                XSDProcessContents pc = wildcard.getProcessContents();
                this.processContentsCombo.setText(pc.getName());
            }
        }
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        XSDConcreteComponent concreteComponent = (XSDConcreteComponent)this.getInput();
        Element element = concreteComponent.getElement();
        if (concreteComponent instanceof XSDWildcard) {
            XSDWildcard wildcard = (XSDWildcard)concreteComponent;
            if (e.widget == this.namespaceCombo) {
                String newValue = this.namespaceCombo.getText();
                boolean removeAttribute = false;
                if (newValue.length() == 0) {
                    removeAttribute = true;
                }
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_NAMESPACE_CHANGE"), element);
                if (removeAttribute) {
                    wildcard.unsetLexicalNamespaceConstraint();
                } else {
                    wildcard.setStringLexicalNamespaceConstraint(newValue);
                }
                this.endRecording(element);
            } else if (e.widget == this.processContentsCombo) {
                String newValue = this.processContentsCombo.getText();
                boolean removeAttribute = false;
                if (newValue.length() == 0) {
                    removeAttribute = true;
                }
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PROCESSCONTENTS_CHANGE"), element);
                if (removeAttribute) {
                    wildcard.unsetProcessContents();
                } else {
                    wildcard.setProcessContents(XSDProcessContents.get((String)this.processContentsCombo.getItem(this.processContentsCombo.getSelectionIndex())));
                }
                this.endRecording(element);
            }
        }
        this.refresh();
    }
}

