/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.BaseGlobalCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;

public class GlobalElementCleanup
extends BaseGlobalCleanup {
    protected String replacementName = null;

    public GlobalElementCleanup(XSDConcreteComponent deletedItem) {
        super(deletedItem);
    }

    protected String getReplacementElementName() {
        if (this.replacementName == null) {
            TypesHelper helper = new TypesHelper(this.schema);
            List elements = helper.getGlobalElements();
            String deletedName = this.getDeletedQName();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name.equals(deletedName)) continue;
                this.replacementName = name;
                break;
            }
        }
        return this.replacementName;
    }

    public void visitElementDeclaration(XSDElementDeclaration element) {
        if (element.isElementDeclarationReference() && this.deletedItem.equals(element.getResolvedElementDeclaration())) {
            if (this.getReplacementElementName() != null) {
                String msg = "_INFO_RESET_ELEMENT_REFERENCE <" + this.getReplacementElementName() + ">";
                this.addMessage(msg, (XSDConcreteComponent)element);
                element.getElement().setAttribute("ref", this.getReplacementElementName());
            } else {
                String msg = "_INFO_REMOVE_ELEMENT_REFERENCE <" + this.getNamedComponentName(element.getContainer()) + ">";
                this.addMessage(msg, element.getContainer());
                this.childrenToRemove.add(element.getElement());
            }
        }
        super.visitElementDeclaration(element);
    }
}

