/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.dialog;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.plugin.EnvPlugin;
import org.eclipse.wst.command.internal.env.ui.EnvironmentUIMessages;
import org.eclipse.wst.command.internal.env.ui.dialog.AntFileImportWizardPage;
import org.eclipse.wst.command.internal.env.ui.plugin.EnvUIPlugin;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.NullStatusHandler;

public class AntFileImportWizard
extends Wizard
implements INewWizard {
    private AntFileImportWizardPage mainPage;
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    static /* synthetic */ Class class$0;

    public AntFileImportWizard() {
        this.setWindowTitle(EnvironmentUIMessages.WIZARD_TITLE_ANT);
    }

    public void setWindowTitle(String newTitle) {
        super.setWindowTitle(newTitle);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new AntFileImportWizardPage(EnvironmentUIMessages.WIZARD_PAGE_TITLE_ANT, this.getSelection());
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IPath destination = this.mainPage.getPath();
        if (destination == null) {
            return false;
        }
        String[] sourceFiles = new String[]{"ant/wsgen.xml", "ant/axisclient.properties", "ant/axisservice.properties"};
        int i = 0;
        while (i < sourceFiles.length) {
            String fileSource = sourceFiles[i];
            String targetFile = fileSource;
            int fileStart = targetFile.lastIndexOf("/");
            if (fileStart >= 0) {
                targetFile = targetFile.substring(fileStart);
            }
            EnvPlugin sourcePlugin = EnvPlugin.getInstance();
            this.copyIFile((Plugin)sourcePlugin, fileSource, destination, targetFile, (IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
        return true;
    }

    private IStatus copyIFile(Plugin plugin, String source, IPath targetPath, String targetFile, IProgressMonitor monitor) {
        if (plugin != null) {
            IPath target = targetPath.append((IPath)new Path(targetFile));
            ProgressUtils.report((IProgressMonitor)monitor, (String)EnvironmentUIMessages.MSG_STATUS_COPYING_ANT_FILES);
            try {
                TransientResourceContext context = new TransientResourceContext();
                context.setOverwriteFilesEnabled(true);
                context.setCreateFoldersEnabled(true);
                context.setCheckoutFilesEnabled(true);
                IResource resource = FileResourceUtils.findResource((IPath)target);
                if (resource != null) {
                    return Status.OK_STATUS;
                }
                FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)plugin.openStream((IPath)new Path(source)), (IProgressMonitor)monitor, (IStatusHandler)new NullStatusHandler());
            }
            catch (Exception e) {
                return StatusUtils.errorStatus((String)EnvironmentUIMessages.MSG_ERR_COPYING_ANT_FILES, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = EnvUIPlugin.getImageDescriptor("icons/full/wizban/newantfiles_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected void selectAndReveal(IResource newResource) {
        AntFileImportWizard.selectAndReveal(newResource, this.getWorkbench().getActiveWorkbenchWindow());
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }
}

