/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.utils;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.UserIdentification;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources;

public class SQLDBUtils {
    protected static int PROPOSAL_TYPE_INVALID = -1;
    protected static int PROPOSAL_TYPE_TABLES = 1;
    protected static int PROPOSAL_TYPE_COLUMNS = 2;

    public static ResultSet executeSQL(Connection conn, String sql) throws SQLException {
        ResultSet result = null;
        Statement statement = null;
        try {
            statement = conn.createStatement();
            result = statement.executeQuery(sql);
        }
        catch (SQLException ex) {
            if (statement != null) {
                statement.close();
            }
            throw ex;
        }
        return result;
    }

    public static boolean isConnected(ConnectionInfo connInfo) {
        boolean connected = false;
        if (connInfo != null && connInfo.getSharedDatabase() != null) {
            connected = true;
        }
        return connected;
    }

    public static boolean isDefaultUser(ConnectionInfo connInfo) {
        String username = null;
        String password = null;
        if (connInfo != null) {
            username = connInfo.getUserName();
            password = connInfo.getPassword();
        }
        return username != null && username.length() == 0 && password != null && password.length() == 0;
    }

    public static boolean isPromptNeeded(ConnectionInfo connInfo) {
        String username = null;
        String password = null;
        if (connInfo != null) {
            username = connInfo.getUserName();
            password = connInfo.getPassword();
        }
        return (username == null || username.length() == 0 || password == null || password.length() == 0) && !SQLDBUtils.isDefaultUser(connInfo);
    }

    public static boolean promptIDPW(ConnectionInfo connInfo, String promptMessage) {
        boolean ok = false;
        if (connInfo != null) {
            UserIdentification idDialog;
            String username = connInfo.getUserName();
            if (username == null || username.length() == 0) {
                username = System.getProperty("user.name");
            }
            if ((idDialog = new UserIdentification(username, promptMessage)).open() == 0) {
                username = idDialog.getUserNameInformation();
                String password = idDialog.getPasswordInformation();
                connInfo.setUserName(username == null ? "" : username);
                connInfo.setPassword(password == null ? "" : password);
                ok = true;
            }
        }
        return ok;
    }

    public static boolean reestablishConnection(ConnectionInfo connInfo) {
        boolean reestablished = false;
        if (connInfo != null) {
            reestablished = true;
            if (!SQLDBUtils.isConnected(connInfo) && SQLDBUtils.isPromptNeeded(connInfo)) {
                if (SQLDBUtils.promptIDPW(connInfo, null)) {
                    try {
                        connInfo.saveConnectionInfo();
                    }
                    catch (Exception exception) {
                        reestablished = false;
                    }
                } else {
                    reestablished = false;
                }
            }
            if (reestablished) {
                StringBuffer msg = new StringBuffer();
                reestablished = SQLDBUtils.testConnection(connInfo, msg);
                if (msg.length() > 0) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SQLEditorResources.getString("SQLEditor.connection.error.connectionFailed.dialogTitle"), (String)SQLEditorResources.getString("SQLEditor.connection.error.connectionFailed.message", new Object[]{msg.toString()}));
                }
            }
        }
        return reestablished;
    }

    public static boolean testConnection(final ConnectionInfo connInfo, final StringBuffer msgBuf) {
        Connection conn;
        boolean connectedOK = false;
        if (connInfo != null) {
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        Connection testConn = connInfo.getSharedConnection();
                        if (testConn == null) {
                            try {
                                testConn = connInfo.connect();
                                if (testConn != null) {
                                    connInfo.setSharedConnection(testConn);
                                    new DatabaseProviderHelper().setDatabase(testConn, connInfo, connInfo.getDatabaseName());
                                    connInfo.saveConnectionInfo();
                                }
                            }
                            catch (Exception e) {
                                msgBuf.append(e.getMessage());
                            }
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if ((conn = connInfo.getSharedConnection()) != null) {
            connectedOK = true;
        }
        return connectedOK;
    }
}

