/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;

public final class BeaninfoProxyConstants {
    private static final Object REGISTRY_KEY = new Object();
    private final IMethodProxy introspectProxy;
    private final IMethodProxy getBeanInfoSearchPathProxy;
    private final IMethodProxy setBeanInfoSearchPathProxy;
    private final IMethodProxy sendBeanInfoProxy;

    public static BeaninfoProxyConstants getConstants(ProxyFactoryRegistry registry) {
        BeaninfoProxyConstants constants = (BeaninfoProxyConstants)registry.getConstants(REGISTRY_KEY);
        if (constants == null) {
            constants = new BeaninfoProxyConstants(registry);
            registry.registerConstants(REGISTRY_KEY, (Object)constants);
        }
        return constants;
    }

    private BeaninfoProxyConstants(ProxyFactoryRegistry registry) {
        IStandardBeanTypeProxyFactory typeFactory = registry.getBeanTypeProxyFactory();
        IBeanTypeProxy introspector = typeFactory.getBeanTypeProxy("java.beans.Introspector");
        this.getBeanInfoSearchPathProxy = introspector.getMethodProxy("getBeanInfoSearchPath");
        this.setBeanInfoSearchPathProxy = introspector.getMethodProxy("setBeanInfoSearchPath", "[Ljava.lang.String;");
        IBeanTypeProxy modelingBeaninfo = typeFactory.getBeanTypeProxy("org.eclipse.jem.internal.beaninfo.vm.ModelingBeanInfo");
        this.introspectProxy = modelingBeaninfo.getMethodProxy("introspect", new String[]{"java.lang.Class", "boolean", "int"});
        this.sendBeanInfoProxy = modelingBeaninfo.getMethodProxy("send");
    }

    public IMethodProxy getSendBeanInfoProxy() {
        return this.sendBeanInfoProxy;
    }

    public IMethodProxy getGetBeanInfoSearchPathProxy() {
        return this.getBeanInfoSearchPathProxy;
    }

    public IMethodProxy getSetBeanInfoSearchPathProxy() {
        return this.setBeanInfoSearchPathProxy;
    }

    public IMethodProxy getIntrospectProxy() {
        return this.introspectProxy;
    }
}

