/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.query.execute;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class QueryOutputHelper {
    Database database = null;
    String objectName = "";
    String statementSource = "";
    OutputItem stmtOutput = null;
    boolean updateOutputItemStatus = true;
    protected Connection jdbcConnection;

    public QueryOutputHelper(Connection connection) {
        this.jdbcConnection = connection;
    }

    public QueryOutputHelper(String statementString, Connection connection) {
        this.statementSource = statementString;
        this.jdbcConnection = connection;
    }

    protected OutputItem getSQLScrapbookOutputItem() {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OutputItem(1, 23, ResourceLoader.INSTANCE.queryString("_UI_SCRAPBOOK_ITEM_TITLE"));
        }
        return this.stmtOutput;
    }

    public boolean runSQLScrapbookQuery() {
        block15: {
            try {
                if (this.jdbcConnection == null) break block15;
                this.getSQLScrapbookOutputItem().setStatus(5);
                try {
                    SQLWarning rsWarningMsgs;
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
                    this.showMessage(this.statementSource);
                    Statement stmt = this.jdbcConnection.createStatement();
                    boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                    if (setLimit) {
                        int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                        stmt.setMaxRows(integer);
                    } else {
                        stmt.setMaxRows(0);
                    }
                    int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
                    if (fieldSize > 0) {
                        stmt.setMaxFieldSize(fieldSize);
                    }
                    stmt.execute(this.statementSource);
                    ResultSet resultSet = null;
                    resultSet = stmt.getResultSet();
                    if (resultSet != null) {
                        this.getOutputItem().setStatus(2);
                        this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));
                        OutputViewAPI.getInstance().showOutputContent(this.getOutputItem(), resultSet);
                        int numDisplayed = OutputViewAPI.getInstance().getRowCount(this.stmtOutput);
                        if (numDisplayed >= 1000) {
                            OutputViewAPI.getInstance().showMessage(this.getOutputItem(), ResourceLoader.INSTANCE.queryString("_UI_MSG_MAX_RECORD_EXCEEDED"), false);
                        } else {
                            OutputViewAPI.getInstance().showMessage(this.getOutputItem(), String.valueOf(numDisplayed) + " " + ResourceLoader.INSTANCE.queryString("_UI_MSG_RECORD_RETURNED"), false);
                        }
                        SQLWarning rsWarningMsgs2 = resultSet.getWarnings();
                        if (rsWarningMsgs2 != null) {
                            this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 3);
                            this.displayMessages(rsWarningMsgs2, this.getOutputItem());
                        }
                    } else {
                        this.getOutputItem().setStatus(2);
                        this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
                    }
                    if ((rsWarningMsgs = stmt.getWarnings()) != null) {
                        this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 3);
                        this.displayMessages(rsWarningMsgs, this.getOutputItem());
                    }
                }
                catch (Exception exception) {
                    this.showErrors(exception.toString(), 4);
                    return false;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 4);
                return false;
            }
            catch (WrappedException e) {
                String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE")) + "\n\n" + e.exception().toString() : e.toString();
                this.showErrors(msg, 4);
                return false;
            }
            catch (Exception e) {
                this.showErrors(e.toString(), 4);
                return false;
            }
        }
        return true;
    }

    public boolean runQuery() {
        block13: {
            try {
                if (this.jdbcConnection == null) break block13;
                this.getOutputItem().setStatus(5);
                boolean continueExecution = this.substituteParameters(this.getOutputItem());
                if (!continueExecution) break block13;
                try {
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
                    this.showMessage(this.statementSource);
                    Statement stmt = this.jdbcConnection.createStatement();
                    boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                    if (setLimit) {
                        int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                        stmt.setMaxRows(integer);
                    } else {
                        stmt.setMaxRows(0);
                    }
                    int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
                    if (fieldSize > 0) {
                        stmt.setMaxFieldSize(fieldSize);
                    }
                    stmt.execute(this.statementSource);
                    ResultSet resultSet = null;
                    resultSet = stmt.getResultSet();
                    if (resultSet != null) {
                        this.getOutputItem().setStatus(2);
                        this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));
                        OutputViewAPI.getInstance().showOutputContent(this.getOutputItem(), resultSet);
                        int numDisplayed = OutputViewAPI.getInstance().getRowCount(this.stmtOutput);
                        if (numDisplayed >= 1000) {
                            OutputViewAPI.getInstance().showMessage(this.getOutputItem(), ResourceLoader.INSTANCE.queryString("_UI_MSG_MAX_RECORD_EXCEEDED"), false);
                        } else {
                            OutputViewAPI.getInstance().showMessage(this.getOutputItem(), String.valueOf(numDisplayed) + " " + ResourceLoader.INSTANCE.queryString("_UI_MSG_RECORD_RETURNED"), false);
                        }
                        SQLWarning rsWarningMsgs = resultSet.getWarnings();
                        if (rsWarningMsgs != null) {
                            this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 3);
                            this.displayMessages(rsWarningMsgs, this.getOutputItem());
                        }
                    }
                }
                catch (Exception exception) {
                    this.showErrors(exception.toString(), 4);
                    return false;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 4);
                return false;
            }
            catch (WrappedException e) {
                String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE")) + "\n\n" + e.exception().toString() : e.toString();
                this.showErrors(msg, 4);
                return false;
            }
            catch (Exception e) {
                this.showErrors(e.toString(), 4);
                return false;
            }
        }
        return true;
    }

    protected void displayMessages(SQLWarning except, OutputItem outputItem) {
        String reason = "";
        reason = except instanceof DataTruncation ? ResourceLoader.INSTANCE.queryString("_WARN_DATA_WAS_TRUNCATED") : ResourceLoader.INSTANCE.queryString("_WARN_SQL_WARNINGS_FOUND");
        OutputViewAPI.getInstance().showMessage(outputItem, reason, false);
        do {
            OutputViewAPI.getInstance().showMessage(outputItem, "SQLState=" + except.getSQLState() + " " + except.getMessage(), false);
        } while ((except = except.getNextWarning()) != null);
    }

    public Database getDatabase() {
        return this.database;
    }

    public Connection getConnection() throws SQLException, Exception {
        if (this.jdbcConnection == null) {
            this.makeLiveConnection();
        }
        return this.jdbcConnection;
    }

    private void makeLiveConnection() throws SQLException, Exception {
    }

    private boolean substituteParameters(OutputItem outputItem) {
        return true;
    }

    Shell getShell() {
        return OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    protected void showErrors(String error, int newStatus) {
        if (this.updateOutputItemStatus) {
            OutputViewAPI.getInstance().updateStatus(this.getOutputItem(), newStatus);
        }
        OutputViewAPI.getInstance().showMessage(this.getOutputItem(), error, false);
    }

    protected OutputItem getOutputItem() {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OutputItem(1, 23, this.objectName);
        }
        return this.stmtOutput;
    }

    public void setOutputItem(OutputItem stmtOutput) {
        this.stmtOutput = stmtOutput;
    }

    public boolean isUpdateOutputItemStatus() {
        return this.updateOutputItemStatus;
    }

    public void setUpdateOutputItemStatus(boolean updateOutputItemStatus) {
        this.updateOutputItemStatus = updateOutputItemStatus;
    }

    public void setStatement(String statementSource) {
        this.statementSource = statementSource;
    }

    public void showMessage(String messageText) {
        OutputViewAPI.getInstance().showMessage(this.getOutputItem(), messageText, false);
    }

    protected OutputItem getDDLExecutionOutputItem(String source) {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OutputItem(1, 23, source);
        }
        return this.stmtOutput;
    }

    public boolean executeDDL(String source) {
        block8: {
            try {
                if (this.jdbcConnection == null) break block8;
                if (this.updateOutputItemStatus) {
                    this.getDDLExecutionOutputItem(source).setStatus(5);
                }
                try {
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
                    this.showMessage(this.statementSource);
                    Statement stmt = this.jdbcConnection.createStatement();
                    stmt.execute(this.statementSource);
                    if (this.updateOutputItemStatus) {
                        this.getOutputItem().setStatus(2);
                    }
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
                }
                catch (Exception exception) {
                    this.showErrors(exception.toString(), 4);
                    return false;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 4);
                return false;
            }
            catch (WrappedException e) {
                String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE")) + "\n\n" + e.exception().toString() : e.toString();
                this.showErrors(msg, 4);
                return false;
            }
            catch (Exception e) {
                this.showErrors(e.toString(), 4);
                return false;
            }
        }
        return true;
    }
}

