/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.util;

import java.io.IOException;
import java.io.InputStream;

public class LazyURLInputStream
extends InputStream {
    private static int debugTotalOpenStreamCount = 0;
    protected InputStream inner;
    protected String url;
    protected boolean error;
    boolean hasMarks;
    boolean pretendFileIsStillOpen;

    public LazyURLInputStream(String url) {
        this.url = url;
        this.inner = null;
        this.pretendFileIsStillOpen = false;
    }

    /*
     * Exception decompiling
     */
    private void createInnerStreamIfRequired() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void closeStream() throws IOException {
        if (this.inner != null && !this.pretendFileIsStillOpen) {
            this.inner.close();
            this.pretendFileIsStillOpen = true;
        }
    }

    public int available() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return 0;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        return this.inner.available();
    }

    public void close() throws IOException {
        if (this.pretendFileIsStillOpen) {
            this.pretendFileIsStillOpen = false;
        } else if (this.inner != null) {
            --debugTotalOpenStreamCount;
            this.inner.close();
        }
    }

    public void mark(int readlimit) {
        if (this.pretendFileIsStillOpen) {
            return;
        }
        this.hasMarks = true;
        try {
            this.createInnerStreamIfRequired();
            this.inner.mark(readlimit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean markSupported() {
        if (this.pretendFileIsStillOpen) {
            return false;
        }
        try {
            this.createInnerStreamIfRequired();
            if (this.inner == null) {
                return false;
            }
            return this.inner.markSupported();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int read() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read();
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read(b);
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read(b, off, len);
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    public void reset() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        this.inner.reset();
    }

    public long skip(long n) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return 0L;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        return this.inner.skip(n);
    }
}

