/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.util.ErrorMessage;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.FileEntityResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineSchemaGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineXSDResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.XMLEntityResolverChain;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.XSDValidator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class InlineSchemaValidator
implements IWSDL11Validator {
    private boolean USE_WSDL_TARGETNAMESPACE = false;
    private final String _WARN_OLD_SCHEMA_NAMESPACE = "_WARN_OLD_SCHEMA_NAMESPACE";
    private final String _WARN_SOAPENC_IMPORTED_SCHEMA = "_WARN_SOAPENC_IMPORTED_SCHEMA";
    private final String EMPTY_STRING = "";
    private final String QUOTE = "'";
    MessageGenerator messagegenerator = null;

    public InlineSchemaValidator() {
        String useNS = System.getProperty("use.wsdl.targetnamespace");
        if (useNS != null && useNS.equals("true")) {
            this.USE_WSDL_TARGETNAMESPACE = true;
        }
    }

    public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        String namespace;
        ArrayList elements = new ArrayList();
        UnknownExtensibilityElement elem = (UnknownExtensibilityElement)element;
        Definition wsdlDefinition = (Definition)parents.get(parents.size() - 1);
        String baseLocation = wsdlDefinition.getDocumentBaseURI();
        Element w3celement = elem.getElement();
        Hashtable parentnamespaces = this.getNamespaceDeclarationsFromParents(wsdlDefinition, w3celement);
        String targetNamespace = w3celement.getAttribute("targetNamespace");
        if (this.USE_WSDL_TARGETNAMESPACE && (targetNamespace == null || targetNamespace.equals(""))) {
            targetNamespace = wsdlDefinition.getTargetNamespace();
            w3celement.setAttribute("targetNamespace", targetNamespace);
        }
        if ((namespace = w3celement.getNamespaceURI()).equals("http://www.w3.org/1999/XMLSchema") || namespace.equals("http://www.w3.org/2000/10/XMLSchema")) {
            valInfo.addWarning(this.messagegenerator.getString("_WARN_OLD_SCHEMA_NAMESPACE", "'http://www.w3.org/2001/XMLSchema'"), element);
        }
        XSDValidator schemav = new XSDValidator();
        InlineXSDResolver inlineEntityResolver = this.getEntityResolver(wsdlDefinition, (Types)parents.get(0), baseLocation, targetNamespace);
        XMLEntityResolverChain entityResolverChain = new XMLEntityResolverChain();
        entityResolverChain.addEntityResolver(inlineEntityResolver);
        entityResolverChain.addEntityResolver(valInfo.getURIResolver());
        entityResolverChain.addEntityResolver(new FileEntityResolver());
        String xsd = InlineSchemaGenerator.createXSDString(w3celement, elements, baseLocation, parentnamespaces, inlineEntityResolver.getInlineSchemaNSs());
        schemav.validateInlineSchema(xsd, targetNamespace, baseLocation, entityResolverChain, inlineEntityResolver, valInfo.getSchemaCache());
        if (InlineSchemaGenerator.soapEncodingRequiredNotImported(elem.getElement(), baseLocation, parentnamespaces)) {
            valInfo.addWarning(this.messagegenerator.getString("_WARN_SOAPENC_IMPORTED_SCHEMA"), element);
        }
        if (!schemav.isValid()) {
            Iterator errors = schemav.getErrors().iterator();
            while (errors.hasNext()) {
                ErrorMessage err = (ErrorMessage)errors.next();
                String uri = err.getURI();
                int line = err.getErrorLine();
                String errmess = err.getErrorMessage();
                errmess = this.replaceNamespace(errmess, namespace);
                if (line > 0) {
                    if (uri == null || uri.equals(valInfo.getFileURI())) {
                        valInfo.addError(errmess, this.getObjectAtLine(line - 1, elements));
                        continue;
                    }
                    if (inlineEntityResolver.isInlineSchema(uri) || uri.equals(String.valueOf(valInfo.getFileURI()) + "#inlineschema")) continue;
                    valInfo.addError(errmess, line, err.getErrorColumn(), uri);
                    continue;
                }
                if (uri == null || inlineEntityResolver.isInlineSchema(uri) || uri.equals(String.valueOf(valInfo.getFileURI()) + "#inlineschema")) continue;
                valInfo.addError(errmess, 0, 0, uri);
            }
        } else {
            XSModel xsModel = schemav.getXSModel();
            valInfo.addSchema(xsModel);
        }
    }

    protected InlineXSDResolver getEntityResolver(Definition wsdlDefinition, Types types, String referenceLocation, String targetNamespace) {
        InlineXSDResolver entityResolver = new InlineXSDResolver();
        List schemas = types.getExtensibilityElements();
        if (schemas != null) {
            String thisNamespace;
            UnknownExtensibilityElement extElem;
            Iterator iSchemas = schemas.iterator();
            TreeSet<String> namespaces = new TreeSet<String>();
            while (iSchemas.hasNext()) {
                extElem = (UnknownExtensibilityElement)iSchemas.next();
                thisNamespace = extElem.getElement().getAttribute("targetNamespace");
                if (thisNamespace == null) continue;
                namespaces.add(thisNamespace);
            }
            iSchemas = schemas.iterator();
            while (iSchemas.hasNext()) {
                extElem = (UnknownExtensibilityElement)iSchemas.next();
                thisNamespace = extElem.getElement().getAttribute("targetNamespace");
                if (thisNamespace == null || thisNamespace.equalsIgnoreCase(targetNamespace)) continue;
                Element element = extElem.getElement();
                Hashtable parentnamespaces = this.getNamespaceDeclarationsFromParents(wsdlDefinition, element);
                String xsd = InlineSchemaGenerator.createXSDString(element, new ArrayList(), referenceLocation, parentnamespaces, namespaces);
                entityResolver.add(thisNamespace, xsd);
            }
        }
        return entityResolver;
    }

    public void setResourceBundle(ResourceBundle rb) {
        this.messagegenerator = new MessageGenerator(rb);
    }

    public void setMessageGenerator(MessageGenerator messgen) {
        this.messagegenerator = messgen;
    }

    protected Hashtable getNamespaceDeclarationsFromParents(Definition wsdlDefinition, Element element) {
        Hashtable<String, String> nss = new Hashtable<String, String>();
        Iterator nameSpaces = wsdlDefinition.getNamespaces().keySet().iterator();
        String XMLNS = "xmlns";
        while (nameSpaces.hasNext()) {
            String nsprefix = XMLNS;
            String ns = (String)nameSpaces.next();
            if (!ns.equalsIgnoreCase("")) {
                nsprefix = String.valueOf(nsprefix) + ":";
            }
            if (element.hasAttribute(String.valueOf(nsprefix) + ns)) continue;
            nss.put(String.valueOf(nsprefix) + ns, wsdlDefinition.getNamespace(ns));
        }
        NamedNodeMap atts = element.getParentNode().getAttributes();
        int attslength = atts.getLength();
        int i = 0;
        while (i < attslength) {
            Node tempnode = atts.item(i);
            String nodename = tempnode.getNodeName();
            if (nodename.indexOf(XMLNS) != -1) {
                nss.put(nodename, tempnode.getNodeValue());
            }
            ++i;
        }
        return nss;
    }

    protected Object getObjectAtLine(int line, List elements) {
        if (line < 0 || line >= elements.size()) {
            line = 0;
        }
        return elements.get(line);
    }

    private String replaceNamespace(String message, String namespace) {
        String xsd2001 = "http://www.w3.org/2001/XMLSchema";
        int start = message.indexOf(xsd2001);
        int end = start + xsd2001.length();
        if (start < 0) {
            return message;
        }
        String startString = message.substring(0, start);
        String endString = message.substring(end, message.length());
        return String.valueOf(startString) + namespace + endString;
    }
}

