/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXMLValidator
implements IXMLValidator {
    protected String uri;
    protected URIResolver uriResolver = null;
    protected List errors = new ArrayList();
    protected StringBuffer schemaLocationString = new StringBuffer();
    protected List ignoredNamespaceList = new ArrayList();
    protected InputStream inputStream = null;
    protected String currentErrorKey = null;
    protected Object[] currentMessageArguments = null;
    protected boolean isChildOfDoc = false;
    protected XMLGrammarPool grammarPool = null;

    public DefaultXMLValidator() {
        this.ignoredNamespaceList.add("http://www.w3.org/1999/XMLSchema");
        this.ignoredNamespaceList.add("http://www.w3.org/2000/10/XMLSchema");
        this.ignoredNamespaceList.add("http://www.w3.org/2001/XMLSchema");
    }

    public void setFile(String uri) {
        this.uri = uri;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setGrammarPool(XMLGrammarPool grammarPool) {
        this.grammarPool = grammarPool;
    }

    public void run() {
        try {
            InputSource validateInputSource;
            StringReader reader1 = null;
            if (this.inputStream != null) {
                String string = this.createStringForInputStream(this.inputStream);
                reader1 = new StringReader(string);
                validateInputSource = new InputSource(this.inputStream);
                validateInputSource.setCharacterStream(reader1);
            } else {
                validateInputSource = new InputSource(this.uri);
            }
            XMLReader reader = this.createXMLReader();
            reader.parse(validateInputSource);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {}
    }

    final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception exception) {}
        return fileString.toString();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List getErrors() {
        return this.errors;
    }

    public void addError(String message, int line, int column, String uri) {
        this.errors.add(new ValidationMessageImpl(message, line, column, 1, uri, this.currentErrorKey, this.currentMessageArguments));
    }

    public void setSchemaLocation(String namespace, String location) {
        if (namespace != null && location != null && !namespace.equalsIgnoreCase("") && !location.equalsIgnoreCase("")) {
            this.schemaLocationString.append(" ").append(namespace).append(" ").append(this.formatURI(location));
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected String formatURI(String uri) {
        String space = "%20";
        StringBuffer newUri = new StringBuffer(uri);
        int newUriLength = newUri.length();
        int i = newUriLength - 1;
        while (i >= 0) {
            if (newUri.charAt(i) == ' ') {
                newUri.replace(i, i + 1, space);
            }
            --i;
        }
        return newUri.toString();
    }

    protected XMLReader createXMLReader() throws Exception {
        SAXParser reader = null;
        try {
            reader = new SAXParser((XMLParserConfiguration)new XMLValidatorParserConfiguration());
            XMLConformanceDefaultHandler conformanceDefaultHandler = new XMLConformanceDefaultHandler();
            reader.setErrorHandler((ErrorHandler)conformanceDefaultHandler);
            reader.setContentHandler((ContentHandler)conformanceDefaultHandler);
            reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", (Object)this.grammarPool);
            reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", (Object)new MyEntityResolver(this.uriResolver));
            reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (Exception exception) {}
        return reader;
    }

    protected class XMLConformanceDefaultHandler
    extends DefaultHandler {
        protected XMLConformanceDefaultHandler() {
        }

        public void error(SAXParseException arg0) throws SAXException {
            String tempURI = arg0.getSystemId();
            if (DefaultXMLValidator.this.inputStream != null && arg0.getSystemId() == null) {
                tempURI = DefaultXMLValidator.this.uri;
            }
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), tempURI);
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), arg0.getSystemId());
        }

        public void warning(SAXParseException arg0) throws SAXException {
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), arg0.getSystemId());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("documentation") && (uri.equals("http://schemas.xmlsoap.org/wsdl/") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema"))) {
                DefaultXMLValidator.this.isChildOfDoc = false;
            }
            super.endElement(uri, localName, qName);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("documentation") && (uri.equals("http://schemas.xmlsoap.org/wsdl/") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema"))) {
                DefaultXMLValidator.this.isChildOfDoc = true;
            }
            super.startElement(uri, localName, qName, atts);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            IURIResolutionResult result;
            String uri;
            if (DefaultXMLValidator.this.isChildOfDoc) {
                return new InputSource();
            }
            if (publicId == null) {
                publicId = systemId;
            }
            if ((uri = (result = DefaultXMLValidator.this.uriResolver.resolve("", publicId, systemId)).getPhysicalLocation()) != null && !uri.equals("")) {
                try {
                    URL entityURL = new URL(uri);
                    InputSource is = new InputSource(result.getLogicalLocation());
                    is.setByteStream(entityURL.openStream());
                    if (is != null) {
                        return is;
                    }
                }
                catch (Exception exception) {}
            }
            try {
                InputSource is = super.resolveEntity(publicId, systemId);
                if (is == null) {
                    throw new IOException();
                }
                return is;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    protected class XMLValidatorParserConfiguration
    extends StandardParserConfiguration {
        protected XMLValidatorParserConfiguration() {
        }

        public XMLErrorHandler getErrorHandler() {
            return new XMLValidatorErrorHandler();
        }

        public XMLEntityResolver getEntityResolver() {
            return new XMLEntityResolver(this){
                final /* synthetic */ XMLValidatorParserConfiguration this$1;
                {
                    this.this$1 = xMLValidatorParserConfiguration;
                }

                public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
                    IURIResolutionResult result;
                    String uri;
                    String publicId;
                    if (XMLValidatorParserConfiguration.access$0((XMLValidatorParserConfiguration)this.this$1).isChildOfDoc) {
                        return new XMLInputSource(rid);
                    }
                    String systemId = rid.getLiteralSystemId();
                    if (systemId == null) {
                        systemId = rid.getNamespace();
                    }
                    if ((publicId = rid.getPublicId()) == null) {
                        publicId = systemId;
                    }
                    if ((uri = (result = XMLValidatorParserConfiguration.access$0((XMLValidatorParserConfiguration)this.this$1).uriResolver.resolve("", publicId, systemId)).getPhysicalLocation()) != null && !uri.equals("")) {
                        try {
                            URL entityURL = new URL(uri);
                            XMLInputSource is = new XMLInputSource(rid.getPublicId(), systemId, result.getLogicalLocation());
                            is.setByteStream(entityURL.openStream());
                            if (is != null) {
                                return is;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    return null;
                }
            };
        }

        protected XMLErrorReporter createErrorReporter() {
            return new XMLErrorReporter(this){
                final /* synthetic */ XMLValidatorParserConfiguration this$1;
                {
                    this.this$1 = xMLValidatorParserConfiguration;
                }

                public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                    XMLValidatorParserConfiguration.access$0((XMLValidatorParserConfiguration)this.this$1).currentErrorKey = key;
                    XMLValidatorParserConfiguration.access$0((XMLValidatorParserConfiguration)this.this$1).currentMessageArguments = arguments;
                    super.reportError(domain, key, arguments, severity);
                }
            };
        }

        static /* synthetic */ DefaultXMLValidator access$0(XMLValidatorParserConfiguration xMLValidatorParserConfiguration) {
            return xMLValidatorParserConfiguration.DefaultXMLValidator.this;
        }
    }

    protected class MyEntityResolver
    implements XMLEntityResolver {
        private URIResolver uriResolver;

        public MyEntityResolver(URIResolver uriResolver) {
            this.uriResolver = uriResolver;
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
            IURIResolutionResult result;
            String uri;
            String publicId;
            if (DefaultXMLValidator.this.isChildOfDoc) {
                return new XMLInputSource(rid);
            }
            String ns = rid.getNamespace();
            if (ns != null && DefaultXMLValidator.this.ignoredNamespaceList.contains(ns)) {
                return new XMLInputSource(rid);
            }
            String systemId = rid.getLiteralSystemId();
            if (systemId == null) {
                systemId = ns;
            }
            if ((publicId = rid.getPublicId()) == null) {
                publicId = systemId;
            }
            if ((uri = (result = this.uriResolver.resolve("", publicId, systemId)).getPhysicalLocation()) != null && !uri.equals("")) {
                try {
                    URL entityURL = new URL(uri);
                    XMLInputSource is = new XMLInputSource(rid.getPublicId(), systemId, result.getLogicalLocation());
                    is.setByteStream(entityURL.openStream());
                    if (is != null) {
                        return is;
                    }
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }

    protected class XMLValidatorErrorHandler
    implements XMLErrorHandler {
        protected XMLValidatorErrorHandler() {
        }

        private void addValidationMessage(String key, XMLParseException exception, int severity) {
            if (severity == 1) {
                DefaultXMLValidator.this.errors.add(new ValidationMessageImpl(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), 1, DefaultXMLValidator.this.uri, key, DefaultXMLValidator.this.currentMessageArguments));
            } else {
                DefaultXMLValidator.this.errors.add(new ValidationMessageImpl(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), 0, DefaultXMLValidator.this.uri, key, DefaultXMLValidator.this.currentMessageArguments));
            }
        }

        public void error(String domain, String key, XMLParseException exception) throws XNIException {
            this.addValidationMessage(key, exception, 2);
        }

        public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
            this.addValidationMessage(key, exception, 3);
        }

        public void warning(String domain, String key, XMLParseException exception) throws XNIException {
            this.addValidationMessage(key, exception, 1);
        }
    }

    protected class MyXMLErrorReporter
    extends XMLErrorReporter {
        protected MyXMLErrorReporter() {
        }

        public XMLErrorHandler getErrorHandler() {
            return new XMLValidatorErrorHandler();
        }

        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
            DefaultXMLValidator.this.currentErrorKey = key;
            DefaultXMLValidator.this.currentMessageArguments = arguments;
            super.reportError(domain, key, arguments, severity);
        }
    }
}

