/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.UserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Sequence;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;

public class Utility {
    private static ConnectionInfo conInfo = null;
    public static final String IBMCLOUDSCAPE = "IBM Cloudscape";
    public static final String INFORMIX = "Informix";
    public static final String ORACLE = "Oracle";
    public static final String SQLSERVER = "SQL Server";
    public static final String DERBY = "Derby";
    public static final String DB2_UDB = "DB2 UDB";
    public static final String DB2_ISERIES = "DB2 UDB iSeries";
    public static final String DB2_ZSERIES = "DB2 UDB zSeries";
    public static final String SYBASE = "Sybase";

    public static DatabaseDefinition getDBDef(Database database) {
        if (database == null) {
            return null;
        }
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
    }

    public static boolean isDB2Server(Database database) {
        if (database == null) {
            return false;
        }
        return Utility.isDB2(Utility.getDBDef(database)) || Utility.isCloudscape(Utility.getDBDef(database));
    }

    public static boolean isDB2(DatabaseDefinition dbDef) {
        String dbname = dbDef.getProduct();
        return dbname.equals(DB2_UDB) || dbname.equals(DB2_ISERIES) || dbname.equals(DB2_ZSERIES);
    }

    public static boolean isCloudscape(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals(IBMCLOUDSCAPE);
    }

    public static boolean isSybase(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals(SYBASE);
    }

    public static boolean isInformix(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals(INFORMIX);
    }

    public static boolean isOracle(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals(ORACLE);
    }

    public static boolean isSQLServer(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals(SQLSERVER);
    }

    public static boolean isDerby(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals(DERBY);
    }

    public static int getVendorType(Database database) {
        DatabaseDefinition dbdef = Utility.getDBDef(database);
        if (Utility.isDB2(dbdef)) {
            return 3;
        }
        if (Utility.isOracle(dbdef)) {
            return 2;
        }
        if (Utility.isSybase(dbdef)) {
            return 4;
        }
        if (Utility.isSQLServer(dbdef)) {
            return 1;
        }
        if (Utility.isInformix(dbdef)) {
            return 6;
        }
        if (Utility.isDerby(dbdef) || Utility.isCloudscape(dbdef)) {
            return 7;
        }
        return 5;
    }

    public static ConnectionInfo getConnectionInfo(Database database) {
        if (database == null) {
            return null;
        }
        conInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)database);
        return conInfo;
    }

    public static int isOkayToDrop(String objName) {
        String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog mb = new MessageDialog(new Shell(), ServerExtensionsPlugin.getString("DROP_ITEM_TITLE", new Object[]{objName}), null, ServerExtensionsPlugin.getString("DROP_MSG", new Object[]{objName}), 3, options, 0);
        mb.open();
        return mb.getReturnCode();
    }

    public static String getSchemaQualifiedName(SQLObject sqlObj) {
        StringBuffer sb = new StringBuffer();
        Schema schema = null;
        if (sqlObj instanceof Table) {
            schema = ((Table)sqlObj).getSchema();
        } else if (sqlObj instanceof Routine) {
            schema = ((Routine)sqlObj).getSchema();
        } else if (sqlObj instanceof Sequence) {
            schema = ((Sequence)sqlObj).getSchema();
        } else if (sqlObj instanceof UserDefinedType) {
            schema = ((UserDefinedType)sqlObj).getSchema();
        }
        if (schema != null) {
            sb.append(schema.getName()).append(".");
        }
        sb.append(sqlObj.getName());
        return sb.toString();
    }

    public static Database navigateToDatabase(SQLObject aSqlObj) {
        Database db = null;
        Schema s = null;
        if (aSqlObj != null) {
            if (aSqlObj instanceof Table) {
                s = ((Table)aSqlObj).getSchema();
            } else if (aSqlObj instanceof Routine) {
                s = ((Routine)aSqlObj).getSchema();
            } else if (aSqlObj instanceof Sequence) {
                s = ((Sequence)aSqlObj).getSchema();
            } else if (aSqlObj instanceof UserDefinedType) {
                s = ((UserDefinedType)aSqlObj).getSchema();
            } else if (aSqlObj instanceof Trigger) {
                s = ((Trigger)aSqlObj).getSchema();
            } else if (aSqlObj instanceof Index) {
                s = ((Index)aSqlObj).getSchema();
            }
            if (s != null) {
                db = s.getDatabase();
            }
        }
        return db;
    }

    public static String getSourceFromFile(File source) {
        try {
            FileInputStream in = new FileInputStream(source);
            byte[] buf = new byte[4];
            int len = ((InputStream)in).read(buf);
            ((InputStream)in).close();
            if (len < 3) {
                if (len > 0 && buf[0] != -2 && buf[0] != -1) {
                    char[] buffer1 = new char[4];
                    StringBuffer sb1 = new StringBuffer(512);
                    FileInputStream in1 = new FileInputStream(source);
                    InputStreamReader sr1 = new InputStreamReader((InputStream)in1, System.getProperty("file.encoding"));
                    BufferedReader r1 = new BufferedReader(sr1);
                    len = r1.read(buffer1);
                    if (len != -1) {
                        sb1.append(buffer1, 0, len);
                    }
                    ((InputStream)in1).close();
                    sr1.close();
                    ((Reader)r1).close();
                    return sb1.toString();
                }
                return null;
            }
            String encoding = null;
            encoding = buf[0] == -2 && buf[1] == -1 ? "UTF-16" : (buf[0] == -1 && buf[1] == -2 ? "UTF-16" : (buf[0] == -17 && buf[1] == -69 && buf[2] == -65 ? "UTF-8" : System.getProperty("file.encoding")));
            char[] buffer2 = new char[4096];
            StringBuffer sb2 = new StringBuffer(4096);
            FileInputStream in2 = new FileInputStream(source);
            InputStreamReader sr2 = new InputStreamReader((InputStream)in2, encoding);
            BufferedReader r2 = new BufferedReader(sr2);
            while ((len = r2.read(buffer2)) != -1) {
                sb2.append(buffer2, 0, len);
            }
            ((InputStream)in2).close();
            sr2.close();
            ((Reader)r2).close();
            return sb2.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

