/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public final class BasicFacetedProjectValidator
implements IFacetedProjectValidator {
    public void validate(IFacetedProject fproj) throws CoreException {
        IRuntime r;
        String runtimeName = ((FacetedProject)fproj).getRuntimeName();
        if (runtimeName != null && !RuntimeManager.isRuntimeDefined(runtimeName)) {
            String msg = NLS.bind((String)Resources.runtimeNotDefined, (Object)runtimeName);
            fproj.createErrorMarker(msg);
        }
        if ((r = fproj.getRuntime()) != null) {
            Iterator itr = fproj.getProjectFacets().iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                if (r.supports(fv)) continue;
                String msg = NLS.bind((String)Resources.facetNotSupported, (Object)fv.toString(), (Object)r.getName());
                fproj.createErrorMarker(msg);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String runtimeNotDefined;
        public static String facetNotSupported;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.BasicFacetedProjectValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.BasicFacetedProjectValidator$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

