/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;

public final class FacetedProjectValidationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.wst.common.project.facet.core.builder";
    public static final String VALIDATORS_EXTENSION_ID = "validators";
    private static final List validators = new ArrayList();

    static {
        FacetedProjectValidationBuilder.readMetadata();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject proj = this.getProject();
        IFacetedProject fproj = ProjectFacetsManager.create(proj);
        proj.deleteMarkers("org.eclipse.wst.common.project.facet.core.validation.marker", true, 2);
        Iterator itr = validators.iterator();
        while (itr.hasNext()) {
            IFacetedProjectValidator validator;
            ValidatorDefinition def = (ValidatorDefinition)itr.next();
            if (!def.isApplicable(fproj.getProjectFacets()) || (validator = def.getValidator()) == null) continue;
            validator.validate(fproj);
        }
        return new IProject[0];
    }

    private static void readMetadata() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", VALIDATORS_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                cfgels.add(elements[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("validator")) {
                ValidatorDefinition def = new ValidatorDefinition();
                def.plugin = config.getDeclaringExtension().getNamespace();
                def.className = config.getAttribute("class");
                if (def.className == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(config, "class");
                } else {
                    IConfigurationElement[] children = config.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        String childName = child.getName();
                        if (childName.equals("facet")) {
                            ProjectFacetRef ref = ProjectFacetRef.read(child);
                            if (ref != null) {
                                def.constraints.add(ref);
                            } else {
                                def = null;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (def != null) {
                        validators.add(def);
                    }
                }
            }
            ++i;
        }
    }

    private static final class ValidatorDefinition {
        public String plugin;
        public String className;
        public IFacetedProjectValidator validator;
        public final List constraints = new ArrayList();
        static /* synthetic */ Class class$0;

        ValidatorDefinition() {
        }

        public boolean isApplicable(Set facets) throws CoreException {
            Iterator itr = this.constraints.iterator();
            while (itr.hasNext()) {
                ProjectFacetRef ref = (ProjectFacetRef)itr.next();
                if (ref.check(facets)) continue;
                return false;
            }
            return true;
        }

        public synchronized IFacetedProjectValidator getValidator() throws CoreException {
            if (this.validator == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object instance = FacetCorePlugin.instantiate(this.plugin, this.className, clazz);
                this.validator = (IFacetedProjectValidator)instance;
            }
            return this.validator;
        }
    }
}

