/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;

public final class VersionMatchExpr {
    private final Versionable versionable;
    private final List subexprs = new ArrayList();

    public VersionMatchExpr(Object versionable, String expr) throws CoreException {
        this((Versionable)versionable, expr);
    }

    public VersionMatchExpr(Versionable versionable, String expr) throws CoreException {
        this.versionable = versionable;
        String[] subexprs = expr.split(",");
        int i = 0;
        while (i < subexprs.length) {
            String subexpr = subexprs[i].trim();
            AbstractVersionOperator op = subexpr.startsWith("<=") ? new LessThanOrEq(this.parseVersion(subexpr, 2)) : (subexpr.startsWith("<") ? new LessThan(this.parseVersion(subexpr, 1)) : (subexpr.startsWith(">=") ? new GreaterThanOrEq(this.parseVersion(subexpr, 2)) : (subexpr.startsWith(">") ? new GreaterThan(this.parseVersion(subexpr, 1)) : new Equals(this.parseVersion(subexpr, 0)))));
            this.subexprs.add(op);
            ++i;
        }
    }

    private IVersion parseVersion(String str, int offset) throws CoreException {
        String verstr = str.substring(offset).trim();
        if (!this.versionable.hasVersion(verstr)) {
            String msg = this.versionable.createVersionNotFoundErrMsg(verstr);
            IStatus st = FacetCorePlugin.createErrorStatus(msg);
            throw new CoreException(st);
        }
        return this.versionable.getVersionInternal(verstr);
    }

    public boolean evaluate(IVersion ver) throws CoreException {
        Iterator itr = this.subexprs.iterator();
        while (itr.hasNext()) {
            if (!((AbstractVersionOperator)itr.next()).evaluate(ver)) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleVersionMatch() {
        return this.subexprs.size() == 1 && this.subexprs.get(0) instanceof Equals;
    }

    public boolean isSimpleAllowNewer() {
        return this.subexprs.size() == 1 && this.subexprs.get(0) instanceof GreaterThanOrEq;
    }

    public String getFirstVersion() {
        return ((AbstractVersionOperator)this.subexprs.get((int)0)).param.getVersionString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator itr = this.subexprs.iterator();
        while (itr.hasNext()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(itr.next().toString());
        }
        return buf.toString();
    }

    private static abstract class AbstractVersionOperator {
        protected final IVersion param;

        public AbstractVersionOperator(IVersion param) {
            this.param = param;
        }

        public boolean evaluate(IVersion fv) throws CoreException {
            Comparator comp = this.param.getVersionable().getVersionComparator();
            int result = comp.compare(fv.getVersionString(), this.param.getVersionString());
            return this.evaluate(result);
        }

        protected abstract boolean evaluate(int var1);
    }

    private static final class Equals
    extends AbstractVersionOperator {
        public Equals(IVersion param) {
            super(param);
        }

        protected boolean evaluate(int result) {
            return result == 0;
        }

        public String toString() {
            return this.param.getVersionString();
        }
    }

    private static final class LessThan
    extends AbstractVersionOperator {
        public LessThan(IVersion param) {
            super(param);
        }

        protected boolean evaluate(int result) {
            return result < 0;
        }

        public String toString() {
            return "<" + this.param.getVersionString();
        }
    }

    private static final class LessThanOrEq
    extends AbstractVersionOperator {
        public LessThanOrEq(IVersion param) {
            super(param);
        }

        protected boolean evaluate(int result) {
            return result <= 0;
        }

        public String toString() {
            return "<=" + this.param.getVersionString();
        }
    }

    private static final class GreaterThan
    extends AbstractVersionOperator {
        public GreaterThan(IVersion param) {
            super(param);
        }

        protected boolean evaluate(int result) {
            return result > 0;
        }

        public String toString() {
            return ">" + this.param.getVersionString();
        }
    }

    private static final class GreaterThanOrEq
    extends AbstractVersionOperator {
        public GreaterThanOrEq(IVersion param) {
            super(param);
        }

        protected boolean evaluate(int result) {
            return result >= 0;
        }

        public String toString() {
            return ">=" + this.param.getVersionString();
        }
    }
}

