/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFolderChange
extends AbstractDeleteChange {
    private final IPath fPath;
    private final boolean fIsExecuteChange;

    public DeleteFolderChange(IFolder folder, boolean isExecuteChange) {
        this(DeleteFolderChange.getFolderPath(folder), isExecuteChange);
    }

    public DeleteFolderChange(IPath path, boolean isExecuteChange) {
        this.fPath = path;
        this.fIsExecuteChange = isExecuteChange;
    }

    public static IPath getFolderPath(IFolder folder) {
        return folder.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    public static IFolder getFolder(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteFolderChange_0, this.fPath.lastSegment());
    }

    public Object getModifiedElement() {
        return DeleteFolderChange.getFolder(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(pm, 0);
        }
        return super.isValid(pm, 3);
    }

    protected void doDelete(IProgressMonitor pm) throws CoreException {
        IFolder folder = DeleteFolderChange.getFolder(this.fPath);
        Assert.isTrue(folder.exists());
        pm.beginTask("", 2);
        folder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile) {
                    DeleteFolderChange.saveFileIfNeeded((IFile)resource, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
        }, 2, false);
        pm.worked(1);
        folder.delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }
}

