/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public abstract class TypeInfo {
    final String fName;
    final String fPackage;
    final char[][] fEnclosingNames;
    int fModifiers;
    public static final int UNRESOLVABLE_TYPE_INFO = 1;
    public static final int JAR_FILE_ENTRY_TYPE_INFO = 2;
    public static final int IFILE_TYPE_INFO = 3;
    static final char SEPARATOR = '/';
    static final char EXTENSION_SEPARATOR = '.';
    static final char PACKAGE_PART_SEPARATOR = '.';

    protected TypeInfo(String pkg, String name, char[][] enclosingTypes, int modifiers) {
        this.fPackage = pkg;
        this.fName = name;
        this.fModifiers = modifiers;
        this.fEnclosingNames = enclosingTypes;
    }

    public int hashCode() {
        return (this.fPackage.hashCode() << 16) + this.fName.hashCode();
    }

    public abstract int getElementType();

    public abstract String getPath();

    protected abstract IJavaElement getContainer(IJavaSearchScope var1) throws JavaModelException;

    public abstract IPath getPackageFragmentRootPath();

    public abstract String getPackageFragmentRootName();

    public int getModifiers() {
        return this.fModifiers;
    }

    public void setModifiers(int modifiers) {
        this.fModifiers = modifiers;
    }

    public String getTypeName() {
        return this.fName;
    }

    public String getPackageName() {
        return this.fPackage;
    }

    public boolean isInterface() {
        return Flags.isInterface((int)this.fModifiers);
    }

    public boolean isEnclosed(IJavaSearchScope scope) {
        return scope.encloses(this.getPath());
    }

    public String getEnclosingName() {
        StringBuffer buf = new StringBuffer();
        if (this.fEnclosingNames != null) {
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                if (i != 0) {
                    buf.append('.');
                }
                buf.append(this.fEnclosingNames[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    public boolean isInnerType() {
        return this.fEnclosingNames != null && this.fEnclosingNames.length > 0;
    }

    public String getTypeQualifiedName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
                ++i;
            }
            buf.append(this.fName);
            return buf.toString();
        }
        return this.fName;
    }

    public String getFullyQualifiedName() {
        StringBuffer buf = new StringBuffer();
        if (this.fPackage.length() > 0) {
            buf.append(this.fPackage);
            buf.append('.');
        }
        if (this.fEnclosingNames != null) {
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
                ++i;
            }
        }
        buf.append(this.fName);
        return buf.toString();
    }

    public String getTypeContainerName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            if (this.fPackage.length() > 0) {
                buf.append(this.fPackage);
            }
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(this.fEnclosingNames[i]);
                ++i;
            }
            return buf.toString();
        }
        return this.fPackage;
    }

    public IType resolveType(IJavaSearchScope scope) throws JavaModelException {
        IJavaElement elem = this.getContainer(scope);
        if (elem instanceof ICompilationUnit) {
            return JavaModelUtil.findTypeInCompilationUnit((ICompilationUnit)elem, this.getTypeQualifiedName());
        }
        if (elem instanceof IClassFile) {
            return ((IClassFile)elem).getType();
        }
        return null;
    }

    protected boolean doEquals(TypeInfo other) {
        return this.fName.equals(other.fName) && this.fPackage.equals(other.fPackage) && CharOperation.equals((char[][])this.fEnclosingNames, (char[][])other.fEnclosingNames);
    }

    protected static boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("path= ");
        buf.append(this.getPath());
        buf.append("; pkg= ");
        buf.append(this.fPackage);
        buf.append("; enclosing= ");
        buf.append(this.getEnclosingName());
        buf.append("; name= ");
        buf.append(this.fName);
        return buf.toString();
    }
}

