/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.FoldingMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private PreferenceAction fToggle;
    private TextOperationAction fExpand;
    private TextOperationAction fCollapse;
    private TextOperationAction fExpandAll;
    private IProjectionListener fProjectionListener;
    static /* synthetic */ Class class$0;

    public FoldingActionGroup(final ITextEditor editor, ITextViewer viewer) {
        if (viewer instanceof ProjectionViewer) {
            this.fViewer = (ProjectionViewer)viewer;
            this.fProjectionListener = new IProjectionListener(){

                public void projectionEnabled() {
                    FoldingActionGroup.this.update();
                }

                public void projectionDisabled() {
                    FoldingActionGroup.this.update();
                }
            };
            this.fViewer.addProjectionListener(this.fProjectionListener);
            this.fToggle = new PreferenceAction(FoldingMessages.getResourceBundle(), "Projection.Toggle.", 2){

                public void run() {
                    IPreferenceStore store;
                    boolean current = (store = JavaPlugin.getDefault().getPreferenceStore()).getBoolean("editor_folding_enabled");
                    store.setValue("editor_folding_enabled", !current);
                }

                public void update() {
                    ITextOperationTarget target;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    boolean isEnabled = (target = (ITextOperationTarget)editor.getAdapter((Class)clazz)) != null && target.canDoOperation(19);
                    this.setEnabled(isEnabled);
                }
            };
            this.fToggle.setChecked(true);
            this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
            editor.setAction("FoldingToggle", (IAction)this.fToggle);
            this.fExpandAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.ExpandAll.", editor, 20, true);
            this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
            editor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
            this.fExpand = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", editor, 17, true);
            this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
            editor.setAction("FoldingExpand", (IAction)this.fExpand);
            this.fCollapse = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", editor, 18, true);
            this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
            editor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        }
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.getProjectionAnnotationModel() != null);
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
        }
    }

    public void fillMenu(IMenuManager manager) {
        if (this.isEnabled()) {
            this.update();
            manager.add((IAction)this.fToggle);
            manager.add((IAction)this.fExpandAll);
            manager.add((IAction)this.fExpand);
            manager.add((IAction)this.fCollapse);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle bundle, String prefix, int style) {
            super(bundle, prefix, style);
        }
    }
}

