/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.spelling.PropertiesValueBreakIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;

public class PropertiesFileSpellingEngine
extends SpellingEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, Locale locale, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellingEngine.SpellEventListener listener = new SpellingEngine.SpellEventListener(collector);
        try {
            try {
                checker.addListener(listener);
                ArrayList<ITypedRegion> partitionList = new ArrayList<ITypedRegion>();
                int i = 0;
                while (i < regions.length) {
                    partitionList.addAll(Arrays.asList(TextUtilities.computePartitioning((IDocument)document, (String)"___pf_partitioning", (int)regions[i].getOffset(), (int)regions[i].getLength(), (boolean)false)));
                    ++i;
                }
                ITypedRegion[] partitions = partitionList.toArray(new ITypedRegion[partitionList.size()]);
                int i2 = 0;
                while (i2 < partitions.length) {
                    ITypedRegion partition = partitions[i2];
                    if ("__pf_comment".equals(partition.getType())) {
                        while (i2 < partitions.length - 1) {
                            ITypedRegion next = partitions[i2 + 1];
                            int gapOffset = partition.getOffset() + partition.getLength();
                            int gapLength = next.getOffset() - gapOffset;
                            if (!"__pf_comment".equals(next.getType()) && !this.isWhitespace(document, next.getOffset(), next.getLength()) || !this.isWhitespace(document, gapOffset, gapLength)) break;
                            partition = new TypedRegion(partition.getOffset(), next.getOffset() + next.getLength() - partition.getOffset(), partition.getType());
                            ++i2;
                        }
                    }
                    if ("__pf_comment".equals(partition.getType()) || "__pf_roperty_value".equals(partition.getType())) {
                        checker.execute(new SpellCheckIterator(document, (IRegion)partition, locale, new PropertiesValueBreakIterator(locale)));
                    }
                    ++i2;
                }
            }
            catch (BadLocationException x) {
                JavaPlugin.log(x);
            }
            Object var15_19 = null;
            checker.removeListener(listener);
            return;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            checker.removeListener(listener);
            throw throwable;
        }
    }

    private boolean isWhitespace(IDocument document, int offset, int length) {
        try {
            int i = 0;
            while (i < length) {
                if (!Character.isWhitespace(document.getChar(offset + i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return false;
        }
    }
}

