/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.eclipse.wst.common.frameworks.internal.ui.WTPActivityHelper;
import org.eclipse.wst.common.navigator.internal.actions.Assert;
import org.eclipse.wst.common.navigator.internal.actions.WizardShortcutAction;

public class WizardActionGroup
extends ActionGroup {
    private Map actions;
    private IWorkbenchWindow window;
    private String type;
    private IWizardRegistry wizardRegistry;
    private String[] wizardActionIds;
    public static final String IMPORT_WIZARD = "importWizards";
    public static final String EXPORT_WIZARD = "exportWizards";
    public static final String NEW_WIZARD = "newWizards";

    public WizardActionGroup(IWorkbenchWindow window, String type) {
        Assert.isNotNull(type);
        this.type = type;
        this.window = window;
    }

    public void fillContextMenu(IMenuManager menu) {
        IAction action = null;
        String[] localNewWizardActionIds = this.wizardActionIds;
        if (localNewWizardActionIds != null) {
            int i = 0;
            while (i < localNewWizardActionIds.length) {
                action = this.getAction(localNewWizardActionIds[i]);
                if (action != null) {
                    menu.add(action);
                }
                ++i;
            }
        }
    }

    protected IAction getAction(String id) {
        IWizardDescriptor descriptor;
        if (id == null || id.length() == 0) {
            return null;
        }
        Object action = (IAction)this.getActions().get(id);
        if (action == null && (descriptor = this.getRegistry().findWizard(id)) != null) {
            action = new WizardShortcutAction(this.window, descriptor);
            this.getActions().put(id, action);
        }
        return WTPActivityHelper.allowUseOf((Object)action) ? action : null;
    }

    private IWizardRegistry getRegistry() {
        if (this.wizardRegistry == null) {
            if (NEW_WIZARD.equals(this.type)) {
                this.wizardRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
            } else if (IMPORT_WIZARD.equals(this.type)) {
                this.wizardRegistry = WorkbenchPlugin.getDefault().getImportWizardRegistry();
            } else if (EXPORT_WIZARD.equals(this.type)) {
                this.wizardRegistry = WorkbenchPlugin.getDefault().getExportWizardRegistry();
            }
        }
        return this.wizardRegistry;
    }

    protected Map getActions() {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        return this.actions;
    }

    public String[] getWizardActionIds() {
        return this.wizardActionIds;
    }

    public void setWizardActionIds(String[] wizardActionIds) {
        this.wizardActionIds = wizardActionIds;
    }
}

