/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.workbench;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterProvider;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomResourceExtensionFilterProvider
implements ExtensionFilterProvider {
    private static final String CUSTOM_FILTERS_PREFERENCE = "CUSTOM_FILTERS_PREFERENCE";
    private static final String ATT_NAME = "name";
    private static final String ATT_PATTERN = "pattern";

    public List getExtensionFilterDescriptors(String extensionId, String viewerId) {
        ArrayList<ExtensionFilterDescriptor> extFilterDescriptors = new ArrayList<ExtensionFilterDescriptor>();
        ExtensionFilterDescriptor extFilterDescriptor = null;
        ResourcePatternFilter vf = null;
        Preferences preferences = WorkbenchNavigatorPlugin.getDefault().getPluginPreferences();
        String knownCustomFilters = preferences.getString(String.valueOf(viewerId) + CUSTOM_FILTERS_PREFERENCE);
        CustomFilter[] customFilters = this.parseCustomFilters(knownCustomFilters);
        int i = 0;
        while (i < customFilters.length) {
            vf = new ResourcePatternFilter();
            vf.setPatterns(new String[]{customFilters[i].pattern});
            boolean enabledByDefault = true;
            extFilterDescriptor = new ExtensionFilterDescriptor(String.valueOf(extensionId) + "." + customFilters[i].pattern, extensionId, customFilters[i].name, customFilters[i].pattern, viewerId, enabledByDefault, (ViewerFilter)vf);
            if (!extFilterDescriptors.contains(extFilterDescriptor)) {
                extFilterDescriptors.add(extFilterDescriptor);
            }
            ++i;
        }
        return extFilterDescriptors;
    }

    private CustomFilter[] parseCustomFilters(String knownCustomFilters) {
        ArrayList<CustomFilter> resultList = new ArrayList<CustomFilter>();
        try {
            StreamSource source = new StreamSource(new StringReader(knownCustomFilters));
            DOMResult result = new DOMResult();
            this.transform(source, result);
            Node node = result.getNode();
            NodeList children = node.getChildNodes();
            CustomFilter filter = null;
            String name = null;
            String pattern = null;
            Node child = null;
            NamedNodeMap attributes = null;
            Node temp = null;
            int i = 0;
            while (i < children.getLength()) {
                child = children.item(i);
                attributes = child.getAttributes();
                temp = attributes.getNamedItem(ATT_NAME);
                name = temp != null ? temp.getNodeValue() : "";
                temp = attributes.getNamedItem(ATT_PATTERN);
                pattern = temp != null ? temp.getNodeValue() : "";
                filter = new CustomFilter(name != null ? name : "", pattern != null ? pattern : "");
                resultList.add(filter);
                ++i;
            }
            resultList.toArray(new CustomFilter[resultList.size()]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new CustomFilter[0];
    }

    private void transform(Source s, Result r) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(s, r);
    }

    public class CustomFilter {
        public final String name;
        public final String pattern;

        public CustomFilter(String name, String pattern) {
            this.name = name;
            this.pattern = pattern;
        }
    }
}

