/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.components.Assert;
import org.eclipse.ui.internal.components.ComponentMessages;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.IDisposable;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.ServiceFactory;

public final class Container
implements IDisposable,
IServiceProvider {
    private ArrayList services = new ArrayList();
    private LinkedList inProgress = null;
    private ServiceFactory defaultContext;
    private boolean verified = false;

    public Container(ServiceFactory context) {
        Assert.isNotNull(context);
        Collection deps = context.getMissingDependencies();
        if (deps.size() != 0) {
            Assert.isTrue(false, String.valueOf(ComponentMessages.Container_missing_dependency) + deps.toArray()[0].toString());
        }
        this.defaultContext = context;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.deallocateComponents(0);
        this.services = null;
    }

    private void deallocateComponents(int index) {
        ComponentInfo info;
        ComponentInfo[] servicesArray = this.services.toArray(new ComponentInfo[this.services.size()]);
        int i = servicesArray.length - 1;
        while (i >= index) {
            info = servicesArray[i];
            try {
                info.dispose();
            }
            catch (Exception e) {
                WorkbenchPlugin.log(e);
            }
            --i;
        }
        this.services = new ArrayList();
        i = 0;
        while (i < index) {
            info = servicesArray[i];
            this.services.add(info);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object getComponent(Object key, ServiceFactory context, IServiceProvider dependencies) throws ComponentException {
        boolean success;
        int start;
        block11: {
            Object object;
            Object existingInstance = this.getExistingComponent(key, context);
            if (existingInstance != null) {
                return existingInstance;
            }
            if (this.inProgress != null) {
                Iterator iter = this.inProgress.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (!next.equals(key)) continue;
                    throw new ComponentException(key, NLS.bind((String)ComponentMessages.Container_cycle_detected, (Object)key.toString()), null);
                }
            } else {
                this.inProgress = new LinkedList();
            }
            this.inProgress.add(key);
            start = this.services.size();
            success = false;
            try {
                ComponentHandle handle = context.createHandle(key, dependencies);
                if (handle == null) break block11;
                if (handle.requiresDisposal()) {
                    this.services.add(new ComponentInfo(key, handle.getInstance(), handle.getDisposable()));
                }
                Object result = handle.getInstance();
                success = true;
                object = result;
                Object var9_12 = null;
                if (!success) {
                    this.deallocateComponents(start);
                }
                this.inProgress.removeLast();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (!success) {
                    this.deallocateComponents(start);
                }
                this.inProgress.removeLast();
                if (!this.inProgress.isEmpty()) throw throwable;
                this.inProgress = null;
                throw throwable;
            }
            if (!this.inProgress.isEmpty()) return object;
            this.inProgress = null;
            return object;
        }
        Object var9_14 = null;
        if (!success) {
            this.deallocateComponents(start);
        }
        this.inProgress.removeLast();
        if (!this.inProgress.isEmpty()) return null;
        this.inProgress = null;
        return null;
    }

    private final Object getExistingComponent(Object key, ServiceFactory context) {
        Iterator iter = this.services.iterator();
        while (iter.hasNext()) {
            ComponentInfo info = (ComponentInfo)iter.next();
            if (!info.getKey().equals(key)) continue;
            return info.getInstance();
        }
        return null;
    }

    public boolean isDisposed() {
        return this.services == null;
    }

    public Object getService(Object key) throws ComponentException {
        try {
            return this.getComponent(key, this.defaultContext, this);
        }
        catch (ComponentException e) {
            throw new ComponentException(key, (Throwable)e);
        }
    }

    private Object getComponentFromFactory(ComponentFactory factory) throws ComponentException {
        return this.getComponent(factory, new SingleFactoryContext(factory), this);
    }

    public boolean hasService(Object key) {
        return this.defaultContext.hasService(key);
    }

    private static class SingleFactoryContext
    extends ServiceFactory {
        private ComponentFactory factory;

        public SingleFactoryContext(ComponentFactory factory) {
            this.factory = factory;
        }

        public ComponentHandle createHandle(Object componentKey, IServiceProvider container) throws ComponentException {
            return this.factory.createHandle(container);
        }

        public Collection getMissingDependencies() {
            return Collections.EMPTY_SET;
        }

        public boolean hasService(Object componentKey) {
            return true;
        }
    }

    private static final class ComponentInfo {
        IDisposable disposable;
        Object component;
        Object key;

        public ComponentInfo(Object key, Object component, IDisposable disposable) {
            this.key = key;
            this.component = component;
            this.disposable = disposable;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getInstance() {
            return this.component;
        }

        public void dispose() {
            if (this.disposable != null) {
                this.disposable.dispose();
            }
        }
    }
}

