/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;

public class XDocletBuildUtility {
    public static final Object FAMILY_MANUAL_BUILD = new Object();
    private static final String XDOCLETBUILDER = "org.eclipse.jst.j2ee.ejb.annotations.xdoclet.xdocletbuilder";

    public static void runNecessaryBuilders(IProgressMonitor monitor, IProject project) throws CoreException {
        if (project != null) {
            XDocletBuildUtility.runNecessaryBuildersForProject(project, monitor);
        } else {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                XDocletBuildUtility.runNecessaryBuildersForProject(projects[i], monitor);
                ++i;
            }
        }
    }

    private static void runNecessaryBuildersForProject(IProject aProject, IProgressMonitor monitor) throws CoreException {
        XDocletBuildUtility buildUtility;
        Job[] buildJobs = Platform.getJobManager().find(FAMILY_MANUAL_BUILD);
        int i = 0;
        while (i < buildJobs.length) {
            BuildJob job;
            Job curr = buildJobs[i];
            if (curr instanceof BuildJob && (job = (BuildJob)curr).isCoveredBy(aProject)) {
                curr.cancel();
            }
            ++i;
        }
        XDocletBuildUtility xDocletBuildUtility = buildUtility = new XDocletBuildUtility();
        xDocletBuildUtility.getClass();
        BuildJob buildJob = xDocletBuildUtility.new BuildJob("XDoclet Build", aProject);
        buildJob.schedule(1000L);
    }

    protected ICommand getXDocletBuilder(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(XDOCLETBUILDER)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    class BuildJob
    extends Job {
        private final IProject fProject;
        ICommand xdocletBuilder;

        private BuildJob(String name, IProject project) {
            super(name);
            this.fProject = project;
            this.xdocletBuilder = this.getXDocletBuilder(project);
        }

        public boolean isCoveredBy(IProject aProject) {
            return this.fProject != null && this.fProject.equals((Object)aProject);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_MANUAL_BUILD;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.xdocletBuilder != null) {
                try {
                    this.fProject.build(6, XDocletBuildUtility.XDOCLETBUILDER, this.xdocletBuilder.getArguments(), monitor);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }

        protected ICommand getXDocletBuilder(IProject aProject) {
            try {
                IProjectDescription description = aProject.getDescription();
                if (description == null) {
                    return null;
                }
                ICommand[] commands = description.getBuildSpec();
                int i = 0;
                while (i < commands.length) {
                    if (commands[i].getBuilderName().equals(XDocletBuildUtility.XDOCLETBUILDER)) {
                        return commands[i];
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            return null;
        }
    }
}

