/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;

public class ValidatorNameFilter {
    private String _nameFilter = null;
    private String nameFilterExtension = null;
    private boolean _include = true;
    private static final String WILDCARD = "*";
    private boolean _isCaseSensitive = true;

    ValidatorNameFilter() {
    }

    String getNameFilter() {
        return this._nameFilter;
    }

    boolean isCaseSensitive() {
        return this._isCaseSensitive;
    }

    boolean isInclude() {
        return this._include;
    }

    boolean isApplicableTo(IResource resource) {
        return this.isApplicableName(resource) && this.isInclude();
    }

    protected void setNameFilterExtension(String filterExt) {
        this.nameFilterExtension = filterExt;
    }

    public boolean isApplicableName(IResource resource) {
        if (this._nameFilter == null) {
            return true;
        }
        String name = resource.getName();
        if (name.equalsIgnoreCase(this._nameFilter)) {
            return true;
        }
        int indexOfStarDot = this._nameFilter.indexOf("*.");
        if (indexOfStarDot != -1) {
            String nameExtension = name.substring(name.indexOf(".") + 1);
            return this.nameFilterExtension.equalsIgnoreCase(nameExtension);
        }
        if (!this.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        return ValidatorNameFilter.verifyNameMatch(this._nameFilter, name);
    }

    void setInclude(String includeValue) {
        if (includeValue != null) {
            this.setInclude(Boolean.valueOf(includeValue));
        }
    }

    void setInclude(boolean includeBool) {
        this._include = includeBool;
    }

    void setNameFilter(String filter) {
        this._nameFilter = filter;
    }

    void setCaseSensitive(String isCaseSensitiveString) {
        if (isCaseSensitiveString != null) {
            this._isCaseSensitive = Boolean.valueOf(isCaseSensitiveString);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("NameFilter:\n\tnameFilter = ");
        buffer.append(this._nameFilter);
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean verifyNameMatch(String filter, String name) {
        StringTokenizer tokenizer = new StringTokenizer(filter, WILDCARD, true);
        boolean wildcardFlag = false;
        while (tokenizer.hasMoreTokens()) {
            int tokenIndex;
            String token = tokenizer.nextToken();
            if (token.equals(WILDCARD)) {
                wildcardFlag = true;
                continue;
            }
            if (wildcardFlag) {
                tokenIndex = name.indexOf(token);
                if (tokenIndex < 0) return false;
                name = name.substring(tokenIndex + token.length());
            } else {
                if (!name.startsWith(token)) return false;
                tokenIndex = token.length();
                name = name.substring(tokenIndex);
            }
            wildcardFlag = false;
        }
        return name.equals("") || wildcardFlag;
    }
}

