/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.extension;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;

public class PreClientAssembleCommand
extends AbstractDataModelOperation {
    private IWebServiceClient webServiceClient_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.earProject_ == null) {
            return Status.OK_STATUS;
        }
        CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
        command.setProjectName(this.earProject_);
        command.setTemplateId("template.jst.ear");
        command.setRequiredFacetVersions(new RequiredFacetVersion[0]);
        command.setServerFactoryId(this.webServiceClient_.getWebServiceClientInfo().getServerFactoryId());
        command.setServerInstanceId(this.webServiceClient_.getWebServiceClientInfo().getServerInstanceId());
        IStatus status = command.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
            return status;
        }
        AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
        associateCommand.setProject(this.project_);
        associateCommand.setModule(this.module_);
        associateCommand.setEARProject(this.earProject_);
        associateCommand.setEar(this.ear_);
        associateCommand.setEnvironment(environment);
        status = associateCommand.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebServiceClient webServiceClient) {
        this.webServiceClient_ = webServiceClient;
    }
}

