/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AddHandlerDialog;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ConfigServiceHandlersTableWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private Composite parent_;
    private boolean isGenSkeletonEnabled_;
    private String outputLocation_;
    private Table handlersTable_;
    private TableViewer tableViewer_;
    private Combo webServiceDescCombo_;
    private Button addButton_;
    private Button removeButton_;
    private Button genSkeletonRadioButton_;
    private Combo sourceLocationCombo_;
    private Hashtable pathsTable_ = new Hashtable();
    private Hashtable wsDescToHandlers_;
    private Hashtable wsDescToPorts_;
    private Hashtable serviceDescNameToDescObj_;
    private String descriptionName_ = null;
    private Vector orderedHandlers_;
    private int DEFAULT_COLUMN_WIDTH = 100;
    private final String INFOPOP_HDLR_WS_HANDLERS = "SHDL0001";
    private final String INFOPOP_HDLR_GEN_SKELETON = "SHDL0002";
    private final String INFOPOP_COMBO_SOURCE_LOC = "SHDL0003";
    private final String INFOPOP_WS_SERVICE_DESC = "SHDL0004";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.parent_ = parent;
        int maxWidth = 130;
        int maxHeight = 600;
        Composite webServiceRefComp = uiUtils.createComposite(this.parent_, 2);
        this.webServiceDescCombo_ = uiUtils.createCombo(webServiceRefComp, ConsumptionUIMessages.LABEL_COMBO_WS_SERVICE_DESC, ConsumptionUIMessages.TOOLTIP_WS_SERVICE_DESC, "SHDL0004", 8);
        this.webServiceDescCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigServiceHandlersTableWidget.this.handleWebServiceDescCombo(evt);
            }
        });
        Composite displayComp = new Composite(parent, 0);
        GridLayout gridlayout = new GridLayout(2, false);
        displayComp.setLayout((Layout)gridlayout);
        displayComp.setLayoutData((Object)uiUtils.createFillAll());
        final Composite handlersComp = uiUtils.createComposite(displayComp, 1);
        GridData griddata = new GridData(1810);
        handlersComp.setLayoutData((Object)griddata);
        handlersComp.setSize(maxWidth, maxHeight);
        Composite buttonsComp = uiUtils.createComposite(displayComp, 1);
        griddata = new GridData(770);
        buttonsComp.setLayoutData((Object)griddata);
        Text handlersText = new Text(handlersComp, 8);
        handlersText.setText(ConsumptionUIMessages.LABEL_HANDLERS_CONFIG);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        handlersText.setLayoutData((Object)gd);
        this.handlersTable_ = uiUtils.createTable(handlersComp, ConsumptionUIMessages.TOOLTIP_EDIT_WS_HANDLERS, "SHDL0001", 67586);
        this.handlersTable_.setHeaderVisible(true);
        this.handlersTable_.setLinesVisible(true);
        Label wsLabel = new Label(buttonsComp, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        Button moveUpButton = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_MOVE_UP, null, null);
        griddata = new GridData(770);
        moveUpButton.setLayoutData((Object)griddata);
        moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleMoveUpButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Button moveDownButton = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_MOVE_DOWN, null, null);
        griddata = new GridData(770);
        moveDownButton.setLayoutData((Object)griddata);
        moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleMoveDownButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        wsLabel = new Label(buttonsComp, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        this.addButton_ = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_ADD, null, null);
        griddata = new GridData(770);
        this.addButton_.setLayoutData((Object)griddata);
        this.addButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton_ = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_REMOVE, null, null);
        griddata = new GridData(770);
        this.removeButton_.setLayoutData((Object)griddata);
        this.removeButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enableRemove(false);
        String[] columns_ = new String[]{ConsumptionUIMessages.LABEL_HANDLER_NAME, ConsumptionUIMessages.LABLE_HANDLER_CLASS, ConsumptionUIMessages.LABEL_HANDLER_PORT};
        final TableColumn[] tableCols = new TableColumn[columns_.length];
        int i = 0;
        while (i < columns_.length) {
            TableColumn tableColumn = new TableColumn(this.handlersTable_, 16384);
            tableColumn.setText(columns_[i]);
            tableColumn.setAlignment(16384);
            tableColumn.setWidth(this.DEFAULT_COLUMN_WIDTH);
            tableColumn.setResizable(true);
            tableCols[i] = tableColumn;
            ++i;
        }
        handlersComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = handlersComp.getClientArea();
                Point preferredSize = ConfigServiceHandlersTableWidget.this.handlersTable_.computeSize(-1, -1);
                int width = area.width - 2 * ConfigServiceHandlersTableWidget.this.handlersTable_.getBorderWidth() - 10;
                if (preferredSize.y > area.height + ConfigServiceHandlersTableWidget.this.handlersTable_.getHeaderHeight()) {
                    Point vBarSize = ConfigServiceHandlersTableWidget.this.handlersTable_.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = ConfigServiceHandlersTableWidget.this.handlersTable_.getSize();
                if (oldSize.x > area.width) {
                    tableCols[0].setWidth(width / 3);
                    tableCols[1].setWidth(width / 3);
                    tableCols[2].setWidth(width - (tableCols[0].getWidth() + tableCols[1].getWidth()));
                    ConfigServiceHandlersTableWidget.this.handlersTable_.setSize(area.width, area.height);
                } else {
                    ConfigServiceHandlersTableWidget.this.handlersTable_.setSize(area.width, area.height);
                    tableCols[0].setWidth(width / 3);
                    tableCols[1].setWidth(width / 3);
                    tableCols[2].setWidth(width - (tableCols[0].getWidth() + tableCols[1].getWidth()));
                }
            }
        });
        this.tableViewer_ = new TableViewer(this.handlersTable_);
        Control control = this.tableViewer_.getControl();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)data);
        this.tableViewer_.setColumnProperties(columns_);
        this.tableViewer_.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigServiceHandlersTableWidget.this.enableRemove(true);
            }
        });
        this.genSkeletonRadioButton_ = uiUtils.createCheckbox(this.parent_, ConsumptionUIMessages.LABEL_BUTTON_GEN_SKELETON, ConsumptionUIMessages.TOOLTIP_BUTTON_GEN_SKELETON, "SHDL0002");
        griddata = new GridData(530);
        this.genSkeletonRadioButton_.setLayoutData((Object)griddata);
        this.genSkeletonRadioButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigServiceHandlersTableWidget.this.handleGenSkeletonRadioButton();
            }
        });
        Composite sourceLocationComp = uiUtils.createComposite(this.parent_, 2);
        this.sourceLocationCombo_ = uiUtils.createCombo(sourceLocationComp, ConsumptionUIMessages.LABEL_COMBO_SOURCE_LOC, ConsumptionUIMessages.TOOLTIP_COMBO_SOURCE_LOC, "SHDL0003", 8);
        this.sourceLocationCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigServiceHandlersTableWidget.this.handleSourceLocationCombo(evt);
            }
        });
        return this;
    }

    private void populateHandlersTable() {
        try {
            int sizeOfHandlers = this.wsDescToHandlers_.size();
            String[] wsRefNames = this.wsDescToHandlers_.keySet().toArray(new String[0]);
            this.webServiceDescCombo_.setItems(wsRefNames);
            if (sizeOfHandlers < 1) {
                this.webServiceDescCombo_.select(0);
                this.webServiceDescCombo_.setEnabled(false);
            } else if (this.descriptionName_ != null) {
                int index = this.webServiceDescCombo_.indexOf(this.descriptionName_);
                if (index != -1) {
                    this.webServiceDescCombo_.select(index);
                }
            } else {
                this.webServiceDescCombo_.select(0);
            }
            String wsRef = this.webServiceDescCombo_.getText();
            if (this.wsDescToHandlers_.get(wsRef) != null) {
                this.orderedHandlers_ = (Vector)this.wsDescToHandlers_.get(wsRef);
                this.tableViewer_.setInput((Object)this.orderedHandlers_);
                this.tableViewer_.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getHandlersList() {
        ArrayList list = new ArrayList();
        if (this.orderedHandlers_ != null && !this.orderedHandlers_.isEmpty()) {
            list.addAll(this.orderedHandlers_);
        }
        return list;
    }

    public Hashtable getWsDescToHandlers() {
        return this.wsDescToHandlers_;
    }

    public void setHandlers(HandlerTableItem[] handlers) {
        this.populateHandlersTable();
    }

    public IStatus getStatus() {
        IStatus finalStatus = Status.OK_STATUS;
        return finalStatus;
    }

    private void handleAddButtonSelected(SelectionEvent event) {
        String descName = this.webServiceDescCombo_.getText();
        WebServiceDescription serviceDesc = (WebServiceDescription)this.serviceDescNameToDescObj_.get(descName);
        AddHandlerDialog dialog = new AddHandlerDialog(this.parent_.getShell(), false);
        dialog.create();
        String[] portNames = this.getPortComponentNames(serviceDesc);
        dialog.setPortNames(portNames);
        dialog.getShell().setSize(500, 200);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getName();
            String className = dialog.getClassName();
            String port = dialog.getPortName();
            HandlerTableItem hi = new HandlerTableItem();
            hi.setHandlerName(name);
            hi.setHandlerClassName(className);
            hi.setPortName(port);
            hi.setWsDescRef(serviceDesc);
            this.orderedHandlers_ = (Vector)this.wsDescToHandlers_.get(descName);
            this.orderedHandlers_.add(hi);
        }
        this.refresh();
    }

    private String[] getPortComponentNames(WebServiceDescription webServiceDesc) {
        EList ports = webServiceDesc.getPortComponents();
        if (ports != null) {
            String[] portNames = new String[ports.size()];
            int i = 0;
            while (i < ports.size()) {
                String pcName;
                PortComponent pc = (PortComponent)ports.get(i);
                portNames[i] = pcName = pc.getPortComponentName();
                ++i;
            }
            return portNames;
        }
        return new String[0];
    }

    private void handleRemoveButtonSelected(SelectionEvent event) {
        this.handleDeleteKeyPressed();
    }

    private void handleMoveUpButtonSelected(SelectionEvent event) {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index != -1 && index > 0) {
            this.orderedHandlers_ = (Vector)this.wsDescToHandlers_.get(this.webServiceDescCombo_.getText());
            Object object = this.orderedHandlers_.remove(index);
            this.orderedHandlers_.insertElementAt(object, index - 1);
            this.tableViewer_.refresh();
        }
    }

    private void handleMoveDownButtonSelected(SelectionEvent event) {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index != -1 && index < this.orderedHandlers_.size() - 1) {
            this.orderedHandlers_ = (Vector)this.wsDescToHandlers_.get(this.webServiceDescCombo_.getText());
            Object object = this.orderedHandlers_.remove(index);
            this.orderedHandlers_.insertElementAt(object, index + 1);
            this.tableViewer_.refresh();
        }
    }

    public void handleSourceLocationCombo(SelectionEvent event) {
        this.outputLocation_ = this.sourceLocationCombo_.getText();
    }

    public void handleGenSkeletonRadioButton() {
        if (this.genSkeletonRadioButton_.isEnabled()) {
            this.isGenSkeletonEnabled_ = this.genSkeletonRadioButton_.getSelection();
        }
    }

    public void handleWebServiceDescCombo(SelectionEvent event) {
        String webServiceRefName;
        Vector hndlers;
        if (this.webServiceDescCombo_.isEnabled() && (hndlers = (Vector)this.wsDescToHandlers_.get(webServiceRefName = this.webServiceDescCombo_.getText())) != null) {
            this.tableViewer_.setInput((Object)hndlers);
            this.tableViewer_.refresh();
        }
    }

    public boolean isGenSkeletonEnabled_() {
        return this.isGenSkeletonEnabled_;
    }

    private void enableRemove(boolean enabled) {
        this.removeButton_.setEnabled(enabled && !this.tableViewer_.getSelection().isEmpty());
    }

    private void handleDeleteKeyPressed() {
        ISelection selection = this.tableViewer_.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            int selectionIndex = this.handlersTable_.getSelectionIndex();
            this.orderedHandlers_ = (Vector)this.wsDescToHandlers_.get(this.webServiceDescCombo_.getText());
            this.orderedHandlers_.remove(selectionIndex);
            this.refresh();
        }
    }

    public void refresh() {
        try {
            this.tableViewer_.setInput(null);
            if (this.orderedHandlers_ != null) {
                this.tableViewer_.setInput((Object)this.orderedHandlers_);
            }
            this.tableViewer_.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setGenSkeletonEnabled(boolean isGenSkeletonEnabled) {
        this.isGenSkeletonEnabled_ = isGenSkeletonEnabled;
        this.genSkeletonRadioButton_.setSelection(isGenSkeletonEnabled);
    }

    public boolean getGenSkeletonEnabled() {
        return this.isGenSkeletonEnabled_;
    }

    public void setSourceOutputLocation(IPath[] locations) {
        this.outputLocation_ = locations[0].toString();
        String[] paths = new String[locations.length];
        int i = 0;
        while (i < locations.length) {
            paths[i] = locations[i].toString();
            this.pathsTable_.put(paths[i], locations[i]);
            ++i;
        }
        this.sourceLocationCombo_.setItems(paths);
        this.sourceLocationCombo_.select(0);
    }

    public IPath getSourceOutputLocation() {
        IPath outputPath = (IPath)this.pathsTable_.get(this.outputLocation_);
        return outputPath;
    }

    public String[] getHandlerClassNames() {
        Vector<String> handlerClasses = new Vector<String>();
        Enumeration e = this.wsDescToHandlers_.keys();
        while (e.hasMoreElements()) {
            String wsDescName = (String)e.nextElement();
            this.orderedHandlers_ = (Vector)this.wsDescToHandlers_.get(wsDescName);
            if (this.orderedHandlers_ == null) continue;
            int i = 0;
            while (i < this.orderedHandlers_.size()) {
                HandlerTableItem hti = (HandlerTableItem)this.orderedHandlers_.get(i);
                handlerClasses.add(hti.getHandlerClassName());
                ++i;
            }
        }
        return handlerClasses.toArray(new String[0]);
    }

    public void setWsRefsToHandlers(Hashtable wsDescToHandlersArray) {
        this.wsDescToHandlers_ = new Hashtable();
        this.wsDescToPorts_ = new Hashtable();
        try {
            if (wsDescToHandlersArray != null) {
                Enumeration wsDesc = wsDescToHandlersArray.keys();
                while (wsDesc.hasMoreElements()) {
                    String wsDescName = (String)wsDesc.nextElement();
                    HandlerTableItem[] handlers = (HandlerTableItem[])wsDescToHandlersArray.get(wsDescName);
                    this.orderedHandlers_ = new Vector();
                    HashSet<String> portNameVector = new HashSet<String>();
                    int i = 0;
                    while (i < handlers.length) {
                        this.orderedHandlers_.add(handlers[i]);
                        String portName = handlers[i].getPortName();
                        portNameVector.add(new String(portName));
                        ++i;
                    }
                    this.wsDescToHandlers_.put(wsDescName, this.orderedHandlers_);
                    this.wsDescToPorts_.put(wsDescName, portNameVector.toArray(new String[0]));
                }
            }
            this.populateHandlersTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescriptionName(String wsDescName) {
        this.descriptionName_ = wsDescName;
    }

    public void setServiceDescNameToDescObj(Hashtable serviceDescNameToDescObj) {
        this.serviceDescNameToDescObj_ = serviceDescNameToDescObj;
    }

    protected class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof HandlerTableItem) {
                HandlerTableItem hti = (HandlerTableItem)object;
                if (columnIndex == 0) {
                    return hti.getHandlerName() != null ? hti.getHandlerName() : "";
                }
                if (columnIndex == 1) {
                    return hti.getHandlerClassName() != null ? hti.getHandlerClassName() : "";
                }
                return hti.getPortName() != null ? hti.getPortName() : "";
            }
            return null;
        }
    }

    protected class ListContentProvider
    implements IStructuredContentProvider {
        protected ListContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof Vector) {
                return ((Vector)element).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }
}

