/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class WSDLSelectionTreeWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private final String INFOPOP_PWWS_PAGE = ".PWWS0001";
    private WebServicesParser webServicesParser;
    private String webServiceURI;
    private Listener statusListener;
    private TreeViewer treeViewer_;
    private TreeContentProvider treeContentProvider;
    private Tree tree_;
    private int pageWidth_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        parent.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWWS_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(this.pluginId_) + ".PWWS0001");
        Label wsdlLabel = new Label(parent, 64);
        wsdlLabel.setText(ConsumptionUIMessages.LABEL_SELECT_WSDL);
        wsdlLabel.setLayoutData((Object)new GridData(256));
        this.tree_ = new Tree(parent, 2820);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.tree_.setLayoutData((Object)gd);
        this.pageWidth_ = this.tree_.getShell().getSize().x;
        this.treeViewer_ = new TreeViewer(this.tree_);
        this.treeContentProvider = new TreeContentProvider();
        this.treeViewer_.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer_.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WSDLSelectionTreeWidget.this.handleTreeSelectionChangedEvent(event);
            }
        });
        return this;
    }

    private void handleTreeSelectionChangedEvent(SelectionChangedEvent event) {
        this.statusListener.handleEvent(new Event());
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
        this.treeViewer_.setInput((Object)this.webServicesParser);
        this.refreshTreeViewer();
    }

    public void setWebServiceURI(String wsURI) {
        this.webServiceURI = wsURI;
        this.treeContentProvider.setWebServiceURI(this.webServiceURI);
        this.refreshTreeViewer();
    }

    public void refreshTreeViewer() {
        if (this.webServicesParser != null && this.webServiceURI != null) {
            this.treeViewer_.refresh();
            Shell shell = this.tree_.getShell();
            if (this.tree_.getSize().x > this.pageWidth_ || shell.getSize().x > this.pageWidth_) {
                this.tree_.setSize(this.pageWidth_, this.tree_.getSize().y);
                shell.setSize(this.pageWidth_, shell.getSize().y);
                shell.computeSize(-1, -1);
                shell.redraw();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.tree_.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.tree_.isEnabled();
    }

    public String getWsdlURI() {
        WebServiceEntity entity = this.getSelectionAsWebServiceEntity();
        if (entity != null) {
            return entity.getURI();
        }
        return this.webServiceURI;
    }

    private WebServiceEntity getSelectionAsWebServiceEntity() {
        IStructuredSelection ssel;
        Object object;
        ISelection sel;
        if (this.treeViewer_ != null && !(sel = this.treeViewer_.getSelection()).isEmpty() && sel instanceof IStructuredSelection && (object = (ssel = (IStructuredSelection)sel).getFirstElement()) instanceof WebServiceEntity) {
            return (WebServiceEntity)object;
        }
        return null;
    }

    public IStatus getStatus() {
        WebServiceEntity wsEntity = this.getSelectionAsWebServiceEntity();
        if (wsEntity == null || wsEntity.getType() != 2) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_SELECTION_MUST_BE_WSDL);
        }
        return Status.OK_STATUS;
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private String webServiceURI;

        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            WebServicesParser parser;
            WebServiceEntity wsEntity;
            if (inputElement instanceof WebServicesParser && (wsEntity = (parser = (WebServicesParser)inputElement).getWebServiceEntityByURI(this.webServiceURI)) != null) {
                return new Object[]{wsEntity};
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof WebServiceEntity) {
                List list = ((WebServiceEntity)parentElement).getChildren();
                Object[] objects = new Object[list.size()];
                int i = 0;
                while (i < objects.length) {
                    objects[i] = list.get(i);
                    ++i;
                }
                return objects;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof WebServiceEntity) {
                return ((WebServiceEntity)element).getParent();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void setWebServiceURI(String wsURI) {
            this.webServiceURI = wsURI;
        }
    }

    private class TreeLabelProvider
    implements ILabelProvider {
        TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            switch (((WebServiceEntity)element).getType()) {
                case 0: {
                    return WebServiceConsumptionUIPlugin.getImageDescriptor("icons/wsil/html.gif").createImage();
                }
                case 1: {
                    return WebServiceConsumptionUIPlugin.getImageDescriptor("icons/wsil/wsil.gif").createImage();
                }
                case 2: {
                    return WebServiceConsumptionUIPlugin.getImageDescriptor("icons/wsil/wsdl.gif").createImage();
                }
            }
            return null;
        }

        public String getText(Object element) {
            return ((WebServiceEntity)element).getURI();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void dispose() {
        }
    }
}

