/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.internal.IMemento;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.jst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.IRuntime;

public abstract class RuntimeClasspathProviderDelegate {
    private List sourceAttachments;
    private String extensionId;
    private Map runtimePathMap = new HashMap();

    public final void initialize(String id) {
        this.extensionId = id;
    }

    public String getClasspathContainerLabel(IRuntime runtime) {
        return null;
    }

    public IClasspathEntry[] resolveClasspathContainer(IRuntime runtime) {
        return null;
    }

    public String getClasspathContainerLabel(IRuntime runtime, String id) {
        return this.getClasspathContainerLabel(runtime);
    }

    public IClasspathEntry[] resolveClasspathContainer(IRuntime runtime, String id) {
        return this.resolveClasspathContainer(runtime);
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime, String id) {
        return this.resolveClasspathContainerImpl(runtime);
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime) {
        if (runtime == null) {
            return new IClasspathEntry[0];
        }
        this.runtimePathMap.put(runtime.getId(), runtime.getLocation());
        IClasspathEntry[] entries = this.resolveClasspathContainer(runtime, "");
        if (entries == null) {
            entries = new IClasspathEntry[]{};
        }
        if (this.sourceAttachments == null) {
            this.load();
        }
        int size = entries.length;
        int size2 = this.sourceAttachments.size();
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size2) {
                SourceAttachmentUpdate sau = (SourceAttachmentUpdate)this.sourceAttachments.get(j);
                if (sau.runtimeId.equals(runtime.getId()) && sau.entry.equals((Object)entries[i].getPath())) {
                    entries[i] = JavaCore.newLibraryEntry((IPath)entries[i].getPath(), (IPath)sau.sourceAttachmentPath, (IPath)sau.sourceAttachmentRootPath, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])sau.attributes, (boolean)false);
                }
                ++j;
            }
            ++i;
        }
        return entries;
    }

    public boolean hasRuntimeClasspathChanged(IRuntime runtime) {
        try {
            IPath path = (IPath)this.runtimePathMap.get(runtime.getId());
            return path != null && !path.equals((Object)runtime.getLocation());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void addJarFiles(File dir, List list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List list, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    RuntimeClasspathProviderDelegate.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List list, File dir, boolean includeSubdirectories) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, includeSubdirectories);
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, String id, IClasspathEntry[] entries) {
        this.requestClasspathContainerUpdate(runtime, entries);
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, IClasspathEntry[] entries) {
        if (runtime == null || entries == null) {
            return;
        }
        this.sourceAttachments = new ArrayList();
        int size = entries.length;
        int i = 0;
        while (i < size) {
            if (entries[i].getSourceAttachmentPath() != null || entries[i].getExtraAttributes() != null) {
                SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                sau.runtimeId = runtime.getId();
                sau.entry = entries[i].getPath();
                sau.sourceAttachmentPath = entries[i].getSourceAttachmentPath();
                sau.sourceAttachmentRootPath = entries[i].getSourceAttachmentRootPath();
                sau.attributes = entries[i].getExtraAttributes();
                this.sourceAttachments.add(sau);
            }
            ++i;
        }
        this.save();
    }

    private void load() {
        this.sourceAttachments = new ArrayList();
        String id = this.extensionId;
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("source-attachment");
            int size = children.length;
            int i = 0;
            while (i < size) {
                try {
                    IMemento[] attrChildren;
                    SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                    sau.runtimeId = children[i].getString("runtime-id");
                    String temp = children[i].getString("entry");
                    if (temp != null) {
                        sau.entry = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-path")) != null) {
                        sau.sourceAttachmentPath = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-root-path")) != null) {
                        sau.sourceAttachmentRootPath = new Path(temp);
                    }
                    if ((attrChildren = children[i].getChildren("attribute")) != null) {
                        int size2 = attrChildren.length;
                        sau.attributes = new IClasspathAttribute[size2];
                        int j = 0;
                        while (j < size2) {
                            String name = attrChildren[j].getString("name");
                            String value = attrChildren[j].getString("value");
                            sau.attributes[j] = JavaCore.newClasspathAttribute((String)name, (String)value);
                            ++j;
                        }
                    }
                    this.sourceAttachments.add(sau);
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Could not load monitor: " + e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load source path info: " + e.getMessage());
        }
    }

    private void save() {
        if (this.sourceAttachments == null) {
            return;
        }
        String id = this.extensionId;
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("classpath");
            Iterator iterator = this.sourceAttachments.iterator();
            while (iterator.hasNext()) {
                SourceAttachmentUpdate sau = (SourceAttachmentUpdate)iterator.next();
                IMemento child = memento.createChild("source-attachment");
                child.putString("runtime-id", sau.runtimeId);
                if (sau.entry != null) {
                    child.putString("entry", sau.entry.toPortableString());
                }
                if (sau.sourceAttachmentPath != null) {
                    child.putString("source-attachment-path", sau.sourceAttachmentPath.toPortableString());
                }
                if (sau.sourceAttachmentRootPath != null) {
                    child.putString("source-attachment-root-path", sau.sourceAttachmentRootPath.toPortableString());
                }
                if (sau.attributes == null) continue;
                int size = sau.attributes.length;
                int i = 0;
                while (i < size) {
                    IClasspathAttribute attr = sau.attributes[i];
                    IMemento attrChild = child.createChild("attribute");
                    attrChild.putString("name", attr.getName());
                    attrChild.putString("value", attr.getValue());
                    ++i;
                }
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error saving source path info", e);
        }
    }

    private class SourceAttachmentUpdate {
        String runtimeId;
        IPath entry;
        IPath sourceAttachmentPath;
        IPath sourceAttachmentRootPath;
        IClasspathAttribute[] attributes;

        SourceAttachmentUpdate() {
        }
    }
}

