/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaMethodJDOMAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyProvider;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public final class EJBGenHelpers {
    private static final String A = "a";
    private static final String AN = "an";
    private static final char[] VOWELS = new char[]{'A', 'a', 'E', 'e', 'I', 'i', 'O', 'o', 'U', 'u'};

    private EJBGenHelpers() {
    }

    public static final String asParameterName(String aString) {
        String name = EJBGenHelpers.firstAsUppercase(aString);
        name = EJBGenHelpers.withVowelPrefix(name);
        return name;
    }

    public static final String firstAsUppercase(String aString) {
        if (aString != null && aString.length() > 0 && !Character.isUpperCase(aString.charAt(0))) {
            char[] chars = aString.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return String.valueOf(chars);
        }
        return aString;
    }

    protected static EjbModuleExtensionHelper getEJBModuleExtension() {
        return IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
    }

    public static final String getPrimitiveWrapper(String type) {
        if (type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("char")) {
            return "java.lang.Character";
        }
        if (type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("double")) {
            return "java.lang.Double";
        }
        return null;
    }

    public static final String getPrimitiveWrapperShortName(String type) {
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("byte")) {
            return "Byte";
        }
        if (type.equals("char")) {
            return "Character";
        }
        if (type.equals("short")) {
            return "Short";
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("double")) {
            return "Double";
        }
        return null;
    }

    public static final boolean isPrimitive(String type) {
        return type.equals("boolean") || type.equals("byte") || type.equals("char") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double");
    }

    public static boolean isRoot(EnterpriseBean anEJB) {
        EnterpriseBean superType;
        return anEJB != null && (superType = EJBGenHelpers.getSupertype(anEJB)) == null;
    }

    protected static EnterpriseBean getSupertype(EnterpriseBean ejb) {
        EjbModuleExtensionHelper helper = EJBGenHelpers.getEjbModuleExtension();
        if (helper != null) {
            return helper.getSuperType(ejb);
        }
        return null;
    }

    protected static EjbModuleExtensionHelper getEjbModuleExtension() {
        return IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
    }

    public static final boolean isVowel(char aChar) {
        int i = 0;
        while (i < VOWELS.length) {
            if (aChar == VOWELS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final String withVowelPrefix(String aString) {
        if (aString != null && aString.length() > 0) {
            char first = aString.charAt(0);
            if (EJBGenHelpers.isVowel(first)) {
                return AN + aString;
            }
            return A + aString;
        }
        return aString;
    }

    public static boolean isArray(String type) {
        if (type != null && type.length() > 0) {
            int index = type.indexOf(91);
            return index > -1;
        }
        return false;
    }

    public static ICompilationUnit getCompilationUnit(JavaClass javaClass) {
        IType type = EJBGenHelpers.getType(javaClass);
        if (type != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static IType getType(JavaClass javaClass) {
        JavaClassJDOMAdaptor adaptor;
        if (javaClass != null && (adaptor = (JavaClassJDOMAdaptor)EcoreUtil.getRegisteredAdapter((EObject)javaClass, (Object)"JavaReflection")) != null) {
            return adaptor.getSourceType();
        }
        return null;
    }

    public static IMethod getMethod(Method javaMethod) {
        JavaMethodJDOMAdaptor adaptor;
        if (javaMethod != null && (adaptor = (JavaMethodJDOMAdaptor)EcoreUtil.getRegisteredAdapter((EObject)javaMethod, (Object)"JavaReflection")) != null) {
            return adaptor.getSourceMethod();
        }
        return null;
    }

    public static ICompilationUnit getWorkingCopy(JavaClass javaClass, WorkingCopyProvider provider, Object shell) throws CoreException {
        ICompilationUnit cu = EJBGenHelpers.getCompilationUnit(javaClass);
        IStatus status = EJBGenHelpers.validateEdit(cu, shell);
        if (cu != null && (status == null || status.isOK())) {
            return provider.getWorkingCopy(cu, false);
        }
        return null;
    }

    public static IMethod getMethod(MethodElement me, WorkingCopyProvider provider, Map typeCache, Object shell) throws CoreException {
        return EJBGenHelpers.getMethod(me, provider, typeCache, shell, true);
    }

    public static IMethod getMethod(MethodElement me, WorkingCopyProvider provider, Map typeCache, Object shell, boolean useWorkingCopy) throws CoreException {
        if (me != null) {
            return EJBGenHelpers.getMethod(me, me.getTypeJavaClass(), provider, typeCache, shell, useWorkingCopy);
        }
        return null;
    }

    public static IMethod getMethod(MethodElement me, JavaClass typeClass, WorkingCopyProvider provider, Object shell, Map typeCache) throws CoreException {
        return EJBGenHelpers.getMethod(me, typeClass, provider, typeCache, shell, false);
    }

    public static IMethod getMethod(MethodElement me, JavaClass typeClass, WorkingCopyProvider provider, Map typeCache, Object shell, boolean useWorkingCopy) throws CoreException {
        IMethod method = null;
        if (me != null) {
            ICompilationUnit cu;
            IType type = EJBGenHelpers.getType(typeClass);
            if (type == null) {
                return null;
            }
            if (type.isBinary() || !useWorkingCopy) {
                method = EJBGenHelpers.getMethod(me, type, typeCache);
            }
            if (method == null && (cu = EJBGenHelpers.getWorkingCopy(typeClass, provider, shell)) != null) {
                method = EJBGenHelpers.getMethod(me, cu.findPrimaryType(), typeCache);
            }
        }
        return method;
    }

    private static IMethod getMethod(MethodElement me, IType type, Map typeCache) throws CoreException {
        IMethod[] children = type.getMethods();
        int i = 0;
        while (i < children.length) {
            List parms;
            String[] typeNames;
            IMethod method = children[i];
            if (method.getElementName().equals(me.getName()) && (typeNames = method.getParameterTypes()).length == (parms = me.getMethodParams()).size()) {
                boolean isMatch = true;
                int j = 0;
                while (j < typeNames.length) {
                    String parm = (String)parms.get(j);
                    String resolvedName = JDOMAdaptor.typeNameFromSignature((String)typeNames[j], (IType)type, (Map)typeCache);
                    if (!resolvedName.equals(parm)) {
                        isMatch = false;
                        break;
                    }
                    ++j;
                }
                if (isMatch) {
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    public static IMethod[] getMethods(QueryMethod query, WorkingCopyProvider provider, Map typeCache, Object shell) throws CoreException {
        return EJBGenHelpers.getMethods(query, provider, typeCache, shell, false);
    }

    public static IMethod[] getMethods(QueryMethod query, WorkingCopyProvider provider, Map typeCache, Object shell, boolean useWorkingCopy) throws CoreException {
        if (query != null) {
            JavaClass[] typeClasses = query.getClientTypeJavaClasses();
            if (typeClasses.length == 1) {
                return new IMethod[]{EJBGenHelpers.getMethod((MethodElement)query, provider, typeCache, shell, useWorkingCopy)};
            }
            ArrayList<IMethod> methods = new ArrayList<IMethod>(4);
            int i = 0;
            while (i < typeClasses.length) {
                IMethod method = EJBGenHelpers.getMethod((MethodElement)query, typeClasses[i], provider, typeCache, shell, useWorkingCopy);
                if (method != null) {
                    methods.add(method);
                }
                ++i;
            }
            IMethod[] result = new IMethod[methods.size()];
            methods.toArray(result);
            return result;
        }
        return null;
    }

    public static String typeNameFromSignature(String sig, IMethod method, Map typeCache) {
        IType type;
        if (sig != null && method != null && (type = method.getDeclaringType()) != null) {
            return JDOMAdaptor.typeNameFromSignature((String)sig, (IType)type, (Map)typeCache);
        }
        return null;
    }

    public static void editMethod(IMethod sourceMethod, IDOMMethod updateMethod, WorkingCopyProvider provider, Object shell) throws JavaModelException, CoreException {
        if (sourceMethod != null && updateMethod != null && !sourceMethod.isBinary()) {
            IMethod wcMethod = EJBGenHelpers.getWorkingCopyMethod(sourceMethod, provider, shell);
            IType type = wcMethod.getDeclaringType();
            IJavaElement sibling = EJBGenHelpers.getSibling(wcMethod, type);
            String formattedSource = String.valueOf(ToolFactory.createCodeFormatter().format(updateMethod.getContents(), 1, null, null)) + "\n";
            wcMethod.delete(true, null);
            type.createMethod(formattedSource, sibling, true, null);
        }
    }

    public static void editMethods(IMethod[] sourceMethods, IDOMMethod[] updateMethods, WorkingCopyProvider provider, Object shell) throws JavaModelException, CoreException {
        if (sourceMethods != null) {
            int i = 0;
            while (i < sourceMethods.length) {
                EJBGenHelpers.editMethod(sourceMethods[i], updateMethods[i], provider, shell);
                ++i;
            }
        }
    }

    public static IMethod getWorkingCopyMethod(IMethod sourceMethod, WorkingCopyProvider provider, Object shell) throws CoreException {
        if (sourceMethod != null && provider != null) {
            ICompilationUnit wc;
            IType type;
            IMethod[] methods;
            ICompilationUnit cu = sourceMethod.getCompilationUnit();
            IStatus status = EJBGenHelpers.validateEdit(cu, shell);
            if (!cu.isWorkingCopy() && (status == null || status.isOK()) && (methods = (type = (wc = provider.getWorkingCopy(sourceMethod.getCompilationUnit(), false)).findPrimaryType()).findMethods(sourceMethod)).length > 0 && methods[0] != null) {
                return methods[0];
            }
        }
        return sourceMethod;
    }

    public static IJavaElement getSibling(IMethod sourceMethod, IType type) throws JavaModelException {
        if (sourceMethod != null && type != null) {
            IJavaElement[] elements = type.getChildren();
            int max = elements.length - 1;
            int i = 0;
            while (i < elements.length) {
                if (elements[i] == sourceMethod && i != max) {
                    return elements[i + 1];
                }
                ++i;
            }
        }
        return null;
    }

    public static IStatus validateEdit(ICompilationUnit cu, Object obj) {
        if (cu != null && !cu.isWorkingCopy()) {
            try {
                IResource res = cu.getUnderlyingResource();
                if (res.getType() == 1 && res.isReadOnly()) {
                    return ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{(IFile)res}, obj);
                }
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runWithJavaCoreWithDelayedValidation(IWorkspaceRunnable workspaceRunnable, IProject project) {
        boolean needsSuspending;
        block8: {
            needsSuspending = !ValidatorManager.getManager().isSuspended(project);
            try {
                try {
                    if (needsSuspending) {
                        ValidatorManager.getManager().suspendValidation(project, true);
                    }
                    JavaCore.run((IWorkspaceRunnable)workspaceRunnable, null);
                }
                catch (CoreException ex) {
                    Logger.getLogger().logError((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (needsSuspending) {
                    ValidatorManager.getManager().suspendValidation(project, false);
                }
                throw throwable;
            }
            {
                Object var4_7 = null;
                if (!needsSuspending) break block8;
            }
            ValidatorManager.getManager().suspendValidation(project, false);
        }
        if (needsSuspending) {
            EnabledValidatorsOperation validationOperation = new EnabledValidatorsOperation(project, true);
            validationOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

