/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.beaninfo.vm;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;

public abstract class BaseBeanInfo
extends SimpleBeanInfo {
    protected static ResourceBundle RESBUNDLE = ResourceBundle.getBundle("org.eclipse.jem.beaninfo.vm.beaninfo");
    public static final String BOUND = "bound";
    public static final String CONSTRAINED = "constrained";
    public static final String PROPERTYEDITORCLASS = "propertyEditorClass";
    public static final String READMETHOD = "readMethod";
    public static final String WRITEMETHOD = "writeMethod";
    public static final String DISPLAYNAME = "displayName";
    public static final String FACTORY_CREATION = "FACTORY_CREATION";
    public static final String EXPERT = "expert";
    public static final String HIDDEN = "hidden";
    public static final String PREFERRED = "preferred";
    public static final String SHORTDESCRIPTION = "shortDescription";
    public static final String CUSTOMIZERCLASS = "customizerClass";
    public static final String CATEGORY = "category";
    public static final String INDEFAULTEVENTSET = "inDefaultEventSet";
    public static final String FIELDPROPERTY = "field";
    public static final String ENUMERATIONVALUES = "enumerationValues";
    public static final String OBSCURE = "ivjObscure";
    public static final String DESIGNTIMEPROPERTY = "ivjDesignTimeProperty";
    public static final String EVENTADAPTERCLASS = "eventAdapterClass";
    public static final String ICONCOLOR16X16URL = "ICON_COLOR_16x16_URL";
    public static final String ICONCOLOR32X32URL = "ICON_COLOR_32x32_URL";
    public static final String ICONMONO16X16URL = "ICON_MONO_16x16_URL";
    public static final String ICONMONO32X32URL = "ICON_MONO_32x32_URL";
    public static final boolean JVM_1_3 = System.getProperty("java.version", "").startsWith("1.3");
    public static final Object[] EMPTY_ARGS = new Object[0];
    private static Method GETCLASS;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            GETCLASS = clazz.getMethod("getClass", null);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static BeanDescriptor createBeanDescriptor(Class cls, Object[] args) {
        Class customizerClass = null;
        int i = 0;
        while (i < args.length) {
            if (CUSTOMIZERCLASS.equals(args[i])) {
                customizerClass = (Class)args[i + 1];
                break;
            }
            i += 2;
        }
        BeanDescriptor bd = new BeanDescriptor(cls, customizerClass);
        int i2 = 0;
        while (i2 < args.length) {
            String key = (String)args[i2];
            Object value = args[i2 + 1];
            BaseBeanInfo.setFeatureDescriptorValue(bd, key, value);
            i2 += 2;
        }
        return bd;
    }

    public static EventSetDescriptor createEventSetDescriptor(Class cls, String name, Object[] args, MethodDescriptor[] lmds, Class listenerType, String addListenerName, String removeListenerName) {
        EventSetDescriptor esd = null;
        Class[] paramTypes = new Class[]{listenerType};
        try {
            Method addMethod = null;
            Method removeMethod = null;
            try {
                addMethod = cls.getMethod(addListenerName, paramTypes);
            }
            catch (Exception ie) {
                BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_get_the_meth1_EXC_"), addListenerName));
            }
            try {
                removeMethod = cls.getMethod(removeListenerName, paramTypes);
            }
            catch (Exception ie) {
                BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_get_the_meth1_EXC_"), removeListenerName));
            }
            esd = new EventSetDescriptor(name, listenerType, lmds, addMethod, removeMethod);
        }
        catch (Exception ie) {
            BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_E1_EXC_"), name));
        }
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            if (INDEFAULTEVENTSET.equals(key)) {
                esd.setInDefaultEventSet((Boolean)value);
            } else {
                BaseBeanInfo.setFeatureDescriptorValue(esd, key, value);
            }
            i += 2;
        }
        return esd;
    }

    public static MethodDescriptor createMethodDescriptor(Class cls, String name, Object[] args, ParameterDescriptor[] params, Class[] paramTypes) {
        MethodDescriptor md = null;
        try {
            Method aMethod = null;
            try {
                aMethod = cls.getMethod(name, paramTypes);
            }
            catch (Exception ie) {
                BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_get_the_meth1_EXC_"), name));
            }
            md = params != null && params.length > 0 ? new MethodDescriptor(aMethod, params) : new MethodDescriptor(aMethod);
        }
        catch (Exception ie) {
            BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_Method_EXC_"), name));
        }
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            BaseBeanInfo.setFeatureDescriptorValue(md, key, value);
            i += 2;
        }
        return md;
    }

    private static PropertyDescriptor createOtherPropertyDescriptor(String name, Class cls) throws IntrospectionException {
        Method readMethod = null;
        Method writeMethod = null;
        String base = BaseBeanInfo.capitalize(name);
        Class[] parameters = new Class[]{};
        try {
            readMethod = cls.getMethod("is" + base, parameters);
        }
        catch (Exception exception) {}
        if (readMethod == null) {
            try {
                readMethod = cls.getMethod("get" + base, parameters);
            }
            catch (Exception exception) {
                readMethod = BaseBeanInfo.findMethod(cls, "get" + base, 0);
            }
        }
        if (readMethod == null) {
            writeMethod = BaseBeanInfo.findMethod(cls, "set" + base, 1);
        } else {
            parameters = new Class[]{readMethod.getReturnType()};
            try {
                writeMethod = cls.getMethod("set" + base, parameters);
            }
            catch (Exception exception) {}
        }
        if (readMethod != null || writeMethod != null) {
            return new PropertyDescriptor(name, readMethod, writeMethod);
        }
        throw new IntrospectionException(MessageFormat.format(RESBUNDLE.getString("Cannot_find_the_acc1_EXC_"), name));
    }

    public static ParameterDescriptor createParameterDescriptor(String name, Object[] args) {
        ParameterDescriptor pd = null;
        try {
            pd = new ParameterDescriptor();
        }
        catch (Exception ie) {
            BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_Param1_EXC_"), name));
        }
        pd.setName(name);
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            BaseBeanInfo.setFeatureDescriptorValue(pd, key, value);
            i += 2;
        }
        return pd;
    }

    public static PropertyDescriptor createFieldPropertyDescriptor(String name, Field field, Object[] args) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(name, null, null);
            pd.setValue(FIELDPROPERTY, field);
            BaseBeanInfo.applyFieldArguments(pd, args);
            pd.setReadMethod(GETCLASS);
            return pd;
        }
        catch (IntrospectionException e) {
            BaseBeanInfo.throwError(e, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_P1_EXC_"), name));
            return null;
        }
    }

    public static PropertyDescriptor createPropertyDescriptor(Class cls, String name, Object[] args) {
        PropertyDescriptor pd = null;
        try {
            pd = new PropertyDescriptor(name, cls);
        }
        catch (IntrospectionException introspectionException) {
            try {
                pd = BaseBeanInfo.createOtherPropertyDescriptor(name, cls);
            }
            catch (IntrospectionException ie) {
                BaseBeanInfo.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_P1_EXC_"), name));
            }
        }
        BaseBeanInfo.applyPropertyArguments(pd, args, cls);
        return pd;
    }

    public void replacePropertyDescriptor(PropertyDescriptor[] pds, String name, Class cls, Object[] args) {
        PropertyDescriptor pd = null;
        int iPD = BaseBeanInfo.findPropertyDescriptor(pds, name);
        if (iPD == -1) {
            return;
        }
        PropertyDescriptor fromPD = pds[iPD];
        try {
            pd = pds[iPD] = new PropertyDescriptor(fromPD.getName(), null, null);
        }
        catch (IntrospectionException e) {
            BaseBeanInfo.throwError(e, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_P1_EXC_"), fromPD.getName()));
        }
        this.clonePropertySettings(fromPD, pd);
        BaseBeanInfo.applyPropertyArguments(pd, args, cls);
    }

    private void clonePropertySettings(PropertyDescriptor fromPD, PropertyDescriptor pd) {
        try {
            pd.setReadMethod(fromPD.getReadMethod());
            pd.setWriteMethod(fromPD.getWriteMethod());
            pd.setPropertyEditorClass(fromPD.getPropertyEditorClass());
            pd.setBound(fromPD.isBound());
            pd.setConstrained(fromPD.isConstrained());
            this.cloneFeatureSettings(fromPD, pd);
        }
        catch (IntrospectionException e) {
            BaseBeanInfo.throwError(e, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_P1_EXC_"), fromPD.getName()));
        }
    }

    private void cloneFeatureSettings(FeatureDescriptor fromFD, FeatureDescriptor fd) {
        fd.setExpert(fromFD.isExpert());
        fd.setHidden(fromFD.isHidden());
        fd.setPreferred(fromFD.isPreferred());
        fd.setShortDescription(fromFD.getShortDescription());
        fd.setDisplayName(fromFD.getDisplayName());
        Enumeration<String> keys = fromFD.attributeNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = fromFD.getValue(key);
            fd.setValue(key, value);
        }
    }

    private static boolean applyCommonPropertyArguments(PropertyDescriptor pd, String key, Object value) {
        if (BOUND.equals(key)) {
            pd.setBound((Boolean)value);
        } else if (CONSTRAINED.equals(key)) {
            pd.setConstrained((Boolean)value);
        } else if (PROPERTYEDITORCLASS.equals(key)) {
            pd.setPropertyEditorClass((Class)value);
        } else {
            return FIELDPROPERTY.equals(key);
        }
        return true;
    }

    private static void applyPropertyArguments(PropertyDescriptor pd, Object[] args, Class cls) {
        int i = 0;
        while (i < args.length) {
            block11: {
                String key = (String)args[i];
                Object value = args[i + 1];
                if (!BaseBeanInfo.applyCommonPropertyArguments(pd, key, value)) {
                    Method method;
                    String methodName;
                    if (READMETHOD.equals(key)) {
                        methodName = (String)value;
                        try {
                            method = cls.getMethod(methodName, new Class[0]);
                            pd.setReadMethod(method);
                        }
                        catch (Exception e) {
                            BaseBeanInfo.throwError(e, MessageFormat.format(RESBUNDLE.getString("{0}_no_read_method_EXC_"), cls, methodName));
                        }
                    } else if (WRITEMETHOD.equals(key)) {
                        methodName = (String)value;
                        try {
                            if (methodName == null) {
                                pd.setWriteMethod(null);
                                break block11;
                            }
                            Class<?> type = pd.getPropertyType();
                            method = cls.getMethod(methodName, type);
                            pd.setWriteMethod(method);
                        }
                        catch (Exception e) {
                            BaseBeanInfo.throwError(e, MessageFormat.format(RESBUNDLE.getString("{0}_no_write_method_EXC_"), cls, methodName));
                        }
                    } else {
                        BaseBeanInfo.setFeatureDescriptorValue(pd, key, value);
                    }
                }
            }
            i += 2;
        }
    }

    private static void applyFieldArguments(PropertyDescriptor pd, Object[] args) {
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            if (!(BaseBeanInfo.applyCommonPropertyArguments(pd, key, value) || READMETHOD.equals(key) || WRITEMETHOD.equals(key))) {
                BaseBeanInfo.setFeatureDescriptorValue(pd, key, value);
            }
            i += 2;
        }
    }

    public static Method findMethod(Class aClass, String methodName, int parameterCount) {
        try {
            Method[] methods = aClass.getMethods();
            int index = 0;
            while (index < methods.length) {
                Method method = methods[index];
                if (method.getParameterTypes().length == parameterCount && method.getName().equals(methodName)) {
                    return method;
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    public static int findPropertyDescriptor(PropertyDescriptor[] pds, String name) {
        int i = 0;
        while (i < pds.length) {
            if (name.equals(pds[i].getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getDefaultEventIndex() {
        return -1;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    public BeanDescriptor getBeanDescriptor() {
        return BaseBeanInfo.createBeanDescriptor(this.getBeanClass(), EMPTY_ARGS);
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            BeanInfo[] result = new BeanInfo[]{Introspector.getBeanInfo(this.getBeanClass().getSuperclass())};
            PropertyDescriptor[] oPDs = result[0].getPropertyDescriptors();
            PropertyDescriptor[] nPDs = this.overridePropertyDescriptors(oPDs);
            if (oPDs != nPDs) {
                result[0] = new OverridePDBeanInfo(result[0], nPDs);
            }
            return result;
        }
        catch (IntrospectionException introspectionException) {
            return new BeanInfo[0];
        }
    }

    protected PropertyDescriptor[] overridePropertyDescriptors(PropertyDescriptor[] pds) {
        return pds;
    }

    public abstract Class getBeanClass();

    public void handleException(Throwable exception) {
        System.err.println(RESBUNDLE.getString("UNCAUGHT_EXC_"));
        exception.printStackTrace();
    }

    private static void setFeatureDescriptorValue(FeatureDescriptor fd, String key, Object value) {
        if (DISPLAYNAME.equals(key)) {
            fd.setDisplayName((String)value);
        } else if (EXPERT.equals(key)) {
            fd.setExpert((Boolean)value);
        } else if (HIDDEN.equals(key)) {
            fd.setHidden((Boolean)value);
        } else if (PREFERRED.equals(key)) {
            fd.setPreferred((Boolean)value);
            if (JVM_1_3) {
                fd.setValue(PREFERRED, value);
            }
        } else if (SHORTDESCRIPTION.equals(key)) {
            fd.setShortDescription((String)value);
        } else {
            fd.setValue(key, value);
        }
    }

    protected static void throwError(Exception e, String s) {
        throw new Error(String.valueOf(e.toString()) + " " + s);
    }

    private static class OverridePDBeanInfo
    implements BeanInfo {
        private BeanInfo originalBeanInfo;
        private PropertyDescriptor[] overridePDs;

        public OverridePDBeanInfo(BeanInfo bi, PropertyDescriptor[] pds) {
            this.originalBeanInfo = bi;
            this.overridePDs = pds;
        }

        public BeanInfo[] getAdditionalBeanInfo() {
            return this.originalBeanInfo.getAdditionalBeanInfo();
        }

        public BeanDescriptor getBeanDescriptor() {
            return this.originalBeanInfo.getBeanDescriptor();
        }

        public int getDefaultEventIndex() {
            return this.originalBeanInfo.getDefaultEventIndex();
        }

        public int getDefaultPropertyIndex() {
            return this.originalBeanInfo.getDefaultPropertyIndex();
        }

        public EventSetDescriptor[] getEventSetDescriptors() {
            return this.originalBeanInfo.getEventSetDescriptors();
        }

        public Image getIcon(int iconKind) {
            return this.originalBeanInfo.getIcon(iconKind);
        }

        public MethodDescriptor[] getMethodDescriptors() {
            return this.originalBeanInfo.getMethodDescriptors();
        }

        public PropertyDescriptor[] getPropertyDescriptors() {
            return this.overridePDs;
        }
    }
}

