/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.page.NewServerComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class NewServerWizardFragment
extends WizardFragment {
    public static final String MODE = "mode";
    public static final byte MODE_EXISTING = 0;
    public static final byte MODE_DETECT = 1;
    public static final byte MODE_MANUAL = 2;
    protected NewServerComposite comp;
    protected IModule module;
    protected String launchMode;
    protected Map fragmentMap = new HashMap();
    protected Map configMap = new HashMap();

    public NewServerWizardFragment() {
    }

    public NewServerWizardFragment(IModule module, String launchMode) {
        this.module = module;
        this.launchMode = launchMode;
    }

    public boolean hasComposite() {
        return true;
    }

    public void enter() {
        super.enter();
        this.getTaskModel().putObject("launch-mode", (Object)this.launchMode);
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new NewServerComposite(parent, wizard, this.module, this.launchMode);
        if (this.getTaskModel() != null) {
            this.comp.setTaskModel(this.getTaskModel());
        }
        return this.comp;
    }

    protected WizardFragment getWizardFragment(String typeId) {
        WizardFragment fragment;
        try {
            fragment = (WizardFragment)this.fragmentMap.get(typeId);
            if (fragment != null) {
                return fragment;
            }
        }
        catch (Exception exception) {}
        fragment = ServerUIPlugin.getWizardFragment(typeId);
        if (fragment != null) {
            this.fragmentMap.put(typeId, fragment);
        }
        return fragment;
    }

    public List getChildFragments() {
        ArrayList listImpl = new ArrayList();
        this.createChildFragments(listImpl);
        return listImpl;
    }

    protected void createChildFragments(List list) {
        if (this.getTaskModel() == null) {
            return;
        }
        Byte b = (Byte)this.getTaskModel().getObject(MODE);
        if (b != null && b == 2) {
            IServerAttributes server;
            WizardFragment sub;
            IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
            if (runtime != null && runtime instanceof IRuntimeWorkingCopy && (sub = this.getWizardFragment(runtime.getRuntimeType().getId())) != null) {
                list.add(sub);
            }
            if ((server = (IServerAttributes)this.getTaskModel().getObject("server")) != null) {
                WizardFragment sub2;
                if (server.getServerType().hasServerConfiguration() && server instanceof ServerWorkingCopy) {
                    ServerWorkingCopy swc = (ServerWorkingCopy)server;
                    swc.importConfiguration(runtime, null);
                }
                if ((sub2 = this.getWizardFragment(server.getServerType().getId())) != null) {
                    list.add(sub2);
                }
            }
        } else if (b != null) {
            b.byteValue();
        }
    }

    public boolean isComplete() {
        if (this.comp == null) {
            return false;
        }
        return this.comp.getServer() != null;
    }

    public IServerWorkingCopy getServer() {
        if (this.comp == null) {
            return null;
        }
        return this.comp.getServer();
    }

    public boolean isPreferredServer() {
        if (this.comp == null) {
            return false;
        }
        return this.comp.isPreferredServer();
    }
}

