/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class BP1305
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1305(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList faultList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (faultList == null || faultList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                String httpHeader = entryContext.getMessageEntry().getHTTPHeaders();
                Vector<String> responseLine = new Vector<String>();
                String startLine = null;
                String statusCode = null;
                StringTokenizer httpMessageTokenizer = new StringTokenizer(httpHeader, "\n\r\f");
                if (httpMessageTokenizer.hasMoreTokens()) {
                    startLine = httpMessageTokenizer.nextToken();
                }
                if (startLine.startsWith("HTTP")) {
                    StringTokenizer startLineTokenizer = new StringTokenizer(startLine, " ");
                    while (startLineTokenizer.hasMoreTokens()) {
                        responseLine.add(startLineTokenizer.nextToken());
                    }
                    statusCode = (String)responseLine.get(1);
                }
                try {
                    if (!statusCode.equals(String.valueOf(500))) {
                        throw new AssertionFailException(httpHeader);
                    }
                }
                catch (AssertionFailException e) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

