/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BreakpointsViewer
extends CheckboxTreeViewer {
    public BreakpointsViewer(Tree tree) {
        super(tree);
    }

    public Item[] getSelectedItems() {
        return this.getSelection(this.getControl());
    }

    public Widget searchItem(Object element) {
        return this.findItem(element);
    }

    public void refreshItem(TreeItem item) {
        this.updateItem((Widget)item, item.getData());
    }

    public IBreakpoint[] getVisibleBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        Object[] elements = ((ITreeContentProvider)this.getContentProvider()).getElements((Object)manager);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            TreeItem item = (TreeItem)this.searchItem(elements[i]);
            if (item != null) {
                this.collectExpandedBreakpoints(item, list);
            }
            ++i;
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    private void collectExpandedBreakpoints(TreeItem item, List list) {
        Object data = item.getData();
        if (data instanceof IBreakpoint) {
            list.add(data);
            return;
        }
        if (item.getExpanded()) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.collectExpandedBreakpoints(items[i], list);
                ++i;
            }
        }
    }

    protected void setSelection(TreeItem item) {
        this.getTree().setSelection(new TreeItem[]{item});
        this.updateSelection(this.getSelection());
    }
}

