/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.filters.NavigatorExtensionFilter;

public class NonSharedProjectFilter  extends NavigatorExtensionFilter {

	/*
	 * @see ViewerFilter
	 */
	public boolean select(CommonViewer aViewer, Object aParentElement, Object anElement) {
		if (anElement instanceof IProject)
			return isSharedProject((IProject)anElement);
		
		if (anElement instanceof IJavaProject)
			return isSharedProject(((IJavaProject)anElement).getProject());

		return true;
	}
	
	private boolean isSharedProject(IProject project) {
		return !project.isAccessible() || RepositoryProvider.isShared(project);
	}
}