/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Apr 1, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets.providers;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ViewActionGroup;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

/**
 * @author Admin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class WorkingSetAwareContentProvider implements ITreeContentProvider{

	public static final String CONTENT_EXTENSION_ID = "org.eclipse.wst.common.navigator.workingsets"; //$NON-NLS-1$
	DelegateShowProjectContentProvider contentProvider;
	static final String TAG_ROOT_MODE= "rootMode"; //$NON-NLS-1$
	private TreeViewer fViewer;
	private Object fInput;
	private WorkingSetModel fWorkingSetModel;
	private int fRootMode;
	private IMemento fMemento;	
	/**
	 * 
	 */
	public WorkingSetAwareContentProvider() {
		super();
		createWorkingSetModel();
		fRootMode = ViewActionGroup.SHOW_WORKING_SETS;
		setProviders();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		return contentProvider.getChildren(parentElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		return contentProvider.getParent(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		return contentProvider.hasChildren(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		return contentProvider.getElements(inputElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		contentProvider.dispose();
		if (fWorkingSetModel != null) {
			fWorkingSetModel.dispose();
		}
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		
		fViewer = (TreeViewer) viewer;
		fInput= newInput;
		contentProvider.inputChanged(viewer,oldInput,newInput);
		
	}
	
	/**
	 * This method should only be called inside this class
	 * and from test cases.
	 */
	public DelegateShowProjectContentProvider createContentProvider() {
		if (showProjects()) 
			return new DelegateShowProjectContentProvider();
		else {
			return new DelegateWorkingSetContentProvider(fWorkingSetModel);
		}
		
	}
	

	private void restoreRootMode(IMemento memento) {
		if (memento != null) {
			Integer value= memento.getInteger(TAG_ROOT_MODE);
			fRootMode= value == null ? ViewActionGroup.SHOW_PROJECTS : value.intValue();
			if (fRootMode != ViewActionGroup.SHOW_PROJECTS && fRootMode != ViewActionGroup.SHOW_WORKING_SETS)
				fRootMode= ViewActionGroup.SHOW_PROJECTS;
		} else {
			fRootMode= ViewActionGroup.SHOW_PROJECTS;
		}
		
		
	}
	
	private void setProviders() {
		//content provider must be set before the label provider
		if (contentProvider != null) {
			if (fViewer != null) {
				contentProvider.inputChanged(fViewer, fViewer.getInput(), null);
				//fViewer.setInput(null);
			}
			contentProvider.dispose();
			
		}
		contentProvider = createContentProvider();
		if (fViewer != null) {
			contentProvider.inputChanged(fViewer, null, fViewer.getInput());
			//fViewer.setInput(this.findInputElement());
		}
	}
	
	public void restoreState(IMemento aMemento) {
		/*
		fMemento= aMemento;
		restoreRootMode(aMemento);
		if (showWorkingSets()) {
			createWorkingSetModel();
		}
		setProviders();*/
		
		
		fMemento= aMemento;
		restoreRootMode(aMemento);
		if (fWorkingSetModel != null) {
			fWorkingSetModel.init(aMemento);
			//addListenersToWorkingSetModel();
			//rootModeChanged(rootMode);
		}
		
		
	
	}

	public void saveState(IMemento aMemento) {
		aMemento.putInteger(TAG_ROOT_MODE, fRootMode);
		if (fWorkingSetModel != null)
			fWorkingSetModel.saveState(aMemento);

	}
	
	public void rootModeChanged(int newMode) {
		fRootMode= newMode;
		/*if (showWorkingSets() && fWorkingSetModel == null) {
			createWorkingSetModel();
			if (getWorkingSetActionGroup() != null) {
				getWorkingSetActionGroup().setWorkingSetModel(fWorkingSetModel);
			}
		}*/
		ISelection selection= fViewer.getSelection();
		Object input= fViewer.getInput();
		boolean isRootInputChange= ResourcesPlugin.getWorkspace().getRoot().equals(input) 
			|| (fWorkingSetModel != null && fWorkingSetModel.equals(input))
			|| input instanceof IWorkingSet;
		try {
			fViewer.getControl().setRedraw(false);
		/*	if (isRootInputChange) {
				fViewer.setInput(null);
			}*/
			setProviders();
			
			//getWorkingSetActionGroup().fillFilters(fViewer);
			/*if (isRootInputChange) {
				fViewer.setInput(findInputElement());
			}*/
			fViewer.setSelection(selection, true);
		} finally {
			fViewer.getControl().setRedraw(true);
		}
		if (isRootInputChange && fWorkingSetModel.needsConfiguration()) {
			ConfigureWorkingSetAction action= new ConfigureWorkingSetAction(fViewer.getControl().getShell());
			action.setWorkingSetModel(fWorkingSetModel);
			action.run();
			fWorkingSetModel.configured();
		}
	}

	

	private void createWorkingSetModel() {
		/*if (fWorkingSetModel != null) {
			fWorkingSetModel.dispose();
		}*/
		Platform.run(new ISafeRunnable() {
			public void run() throws Exception {
				fWorkingSetModel= fMemento != null 
				? new WorkingSetModel(fMemento) 
				: new WorkingSetModel();
			}
			public void handleException(Throwable exception) {
				fWorkingSetModel= new WorkingSetModel();
			}
		});
	}

	public WorkingSetModel getWorkingSetModel() {
		return fWorkingSetModel;
	}
	
	public int getRootMode() {
		return fRootMode;
	}
	
	/* package */ boolean showProjects() {
		return fRootMode == ViewActionGroup.SHOW_PROJECTS;
	}
	
	/* package */ boolean showWorkingSets() {
		return fRootMode == ViewActionGroup.SHOW_WORKING_SETS;
	}
	
	private Object getDefaultRoot() {
		return ResourcesPlugin.getWorkspace().getRoot();
	}
	
	/**
	 * @param viewActionGroup
	 */
	/*public void setViewActionGroup(ViewActionGroup viewActionGroup) {
		fViewActionGroup = viewActionGroup;
		if (fViewer != null) {
			//setViewerInput();
			fViewActionGroup.fillFilters(fViewer);
		}
			
	}*/
	
	/*private void setViewerInput() {
		if (fViewer != null) {
			try {
				fViewer.getControl().setRedraw(false);
				Object oldInput = fViewer.getInput() ;
				Object inputElement = findInputElement() ;
				
				if (oldInput != inputElement) {
					//ISelection selection = fViewer.getSelection();
					fViewer.setInput(inputElement);
					fViewer.refresh();
					//fViewer.setSelection(selection, true);
				}
			}
			finally {
				fViewer.getControl().setRedraw(true);
			}
		}
		
		
	}*/

	/**
	 * @param event
	 */
	public void workingSetModelChanged(PropertyChangeEvent event) {
		if (ViewActionGroup.MODE_CHANGED.equals(event.getProperty())) {
			rootModeChanged(((Integer)event.getNewValue()).intValue());
//			Object oldInput= null;
//			Object newInput= null;
//			if (showProjects()) {
//				oldInput= getWorkingSetModel();
//				newInput= JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
//			} else if (showWorkingSets()) {
//				oldInput= JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
//				newInput= getWorkingSetModel();
//			}
//			if (oldInput != null && newInput != null) {
//				Frame frame;
//				for (int i= 0; (frame= fFrameList.getFrame(i)) != null; i++) {
//					if (frame instanceof TreeFrame) {
//						TreeFrame treeFrame= (TreeFrame)frame;
//						if (oldInput.equals(treeFrame.getInput()))
//							treeFrame.setInput(newInput);
//					}
//				}
//			}
		} else {
			IWorkingSet workingSet= (IWorkingSet) event.getNewValue();
		
			String property= event.getProperty();
			if (IWorkingSetManager.CHANGE_WORKING_SET_CONTENT_CHANGE.equals(property)) {
				if (fViewer != null) {
					fViewer.getControl().setRedraw(false);
					fViewer.refresh();
					fViewer.getControl().setRedraw(true);
				}
			}
		}
		
	}


	
	

}
