/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.jdt.internal.ui.filters.FilterDescriptor;
import org.eclipse.jdt.internal.ui.filters.NamePatternFilter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterProvider;

/**
 * @author mdelder
 *  
 */
public class JavaElementExtensionFilterProvider implements ExtensionFilterProvider {

	private static final Set ignoredFilters = new HashSet();
	
	static {
		ignoredFilters.add("org.eclipse.jdt.ui.PackageExplorer.NonJavaProjectsFilter");
		ignoredFilters.add("org.eclipse.jdt.ui.PackageExplorer.ClosedProjectsFilter");
		ignoredFilters.add("org.eclipse.jdt.ui.PackageExplorer.NonSharedProjectsFilter");
	}
	
	/**
	 *  
	 */
	public JavaElementExtensionFilterProvider() {
		super();
	}

	/*
	 * (non-Javadoc) @return a List of ExtensionFilterDescriptor (s)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.filters.ExtensionFilterProvider#getExtensionFilterDescriptors(java.lang.String)
	 */
	public List getExtensionFilterDescriptors(String extensionId, String viewerId) {
		FilterDescriptor[] descriptors = FilterDescriptor.getFilterDescriptors("org.eclipse.jdt.ui.PackageExplorer"); //$NON-NLS-1$
		List extFilterDescriptors = new ArrayList();
		ExtensionFilterDescriptor extFilterDescriptor = null;
		ViewerFilter vf = null;
		for (int i = 0; i < descriptors.length; i++) {
			if(!ignoredFilters.contains(descriptors[i].getId())) {
				if (descriptors[i].isCustomFilter())
					vf = descriptors[i].createViewerFilter();
				else if (descriptors[i].isPatternFilter()) { 
					vf = new NamePatternFilter();
					((NamePatternFilter) vf).setPatterns(new String[]{descriptors[i].getPattern()});
				} else
					continue;
				extFilterDescriptor = new ExtensionFilterDescriptor(descriptors[i].getId(), extensionId, descriptors[i].getName(), descriptors[i].getDescription(), viewerId, descriptors[i].isEnabled(), vf);
	
				if (!extFilterDescriptors.contains(extFilterDescriptor))
					extFilterDescriptors.add(extFilterDescriptor);
			}
		}
		
		return extFilterDescriptors;
	}
}
