/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Feb 19, 2004
 *  
 */
package org.eclipse.jst.common.navigator.internal.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

/**
 * @author mdelder
 *  
 */
public  class CommonAdapterFactoryContentProvider extends AdapterFactoryContentProvider {

	

	/**
	 * @param adapterFactory
	 */
	public CommonAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	public void notifyChanged(final Notification notification) {
		final AbstractTreeViewer abstractViewer = getViewer();
		if (abstractViewer == null) {
			// site.notifyElementReplaced(getContainingExtension(), null);
			return;
		}
		
		if (Display.getCurrent() != null) {
			processNotificationChanged(notification, abstractViewer);
		} else {
			/* Create and schedule a UI Job to update the Navigator Content Viewer */
			new UIJob("Update the Viewer for the Common Adapter Factory Content Provider") { //$NON-NLS-1$
				public IStatus runInUIThread(IProgressMonitor monitor) {
					try {
						processNotificationChanged(notification, abstractViewer);
					} catch (RuntimeException e) { 
						e.printStackTrace();
					}
					return Status.OK_STATUS;
				}
			}.schedule();
		}
		
		
	}


	/**
	 * @param notification
	 * @param abstractViewer
	 */
	private void processNotificationChanged(final Notification notification, AbstractTreeViewer abstractViewer) {
		switch (notification.getEventType()) {
			case Notification.ADD : {
				if (notification.getNewValue() != null && isValidChild(notification.getNotifier(), notification.getNewValue()))
					abstractViewer.add(notification.getNotifier(), notification.getNewValue());
				return;
			}
			case Notification.ADD_MANY : {
				if (notification.getNewValue() != null && notification.getNewValue() instanceof Collection) {
					Object[] objects = ((Collection) notification.getNewValue()).toArray();
						abstractViewer.add(notification.getNotifier(), filterValidChild(notification.getNotifier(), objects));
				} /*
				   * else
				   */
				return;
			}
			case Notification.MOVE : {
				abstractViewer.refresh(notification.getNotifier(), true);
				return;
			}
			case Notification.REMOVE : {
				if (notification.getOldValue() != null)
					abstractViewer.remove(notification.getOldValue());
				else
					abstractViewer.refresh(notification.getNotifier(), true);
				return;
			}
			case Notification.REMOVE_MANY : {
				if (notification.getOldValue() != null) {
					Object[] objects = ((Collection) notification.getOldValue()).toArray();
					abstractViewer.remove(objects);
				} else
					abstractViewer.refresh(notification.getNotifier(), true);
				return;
			}
			case Notification.SET : {
				abstractViewer.refresh(notification.getNotifier(), true);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		Object parent = super.getParent(element);
		if (isValidChild(parent, element))
			return parent;

		return findChild(parent, element);
	}

	/**
	 * @param parent
	 * @param element
	 * @return
	 */
	private Object findChild(Object parent, Object element) {
		Object[] children = getChildren(parent);
		if (contains(children, element))
			return parent;
		for (int i = 0; i < children.length; i++) {
			if ((parent = findChild(children[i], element)) != null)
				return parent;
		}
		return null;
	}

	/**
	 * @param object
	 * @param object2
	 * @return
	 */
	private boolean isValidChild(Object parent, Object element) {
		if (parent == null)
			return false;
		Object[] children = getChildren(parent);
		return contains(children, element);
	}

	private boolean contains(Object[] children, Object element) {
		if (children == null || children.length == 0)
			return false;
		for (int i = 0; i < children.length; i++) {
			if (children[i].equals(element))
				return true;
		}
		return false;
	}

	/**
	 * @param object
	 * @param object2
	 * @return
	 */
	private Object[] filterValidChild(Object parent, Object[] elements) {
		Object[] childrenArray = getChildren(parent);
		List children = new ArrayList();
		for (int i = 0; i < childrenArray.length; i++)
			children.add(childrenArray[i]);
		children.retainAll(Arrays.asList(elements));
		return children.toArray();
	}

	

	private AbstractTreeViewer getViewer() {
		if (viewer instanceof AbstractTreeViewer)
			return (AbstractTreeViewer) viewer;
		return null;
	}
}
