/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Jan 22, 2005
 * 
 * TODO To change the template for this generated file go to Window - Preferences - Java - Code
 * Style - Code Templates
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.util.Comparator;

import org.eclipse.ui.views.navigator.ResourceSorter;


public class GroupsComparator implements Comparator {

	private ResourceSorter sorter = new ResourceSorter(ResourceSorter.NAME);
	
	public GroupsComparator() {}

	/**
	 * (non-Javadoc)
	 * 
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2) {
		if (o2 instanceof NavigatorGroup) {
			NavigatorGroup rvalue = (NavigatorGroup) o2;
			if (o1 instanceof NavigatorGroup) {
				NavigatorGroup lvalue = (NavigatorGroup) o1;
				if (lvalue.getSortOrder() != rvalue.getSortOrder())
					return lvalue.getSortOrder() - rvalue.getSortOrder();
				return lvalue.getDisplayName().compareTo(rvalue.getDisplayName());
			}
			if (rvalue.getSortOrder() > 100000)
				return -1;
		}
		return sorter.compare(null, o1, o2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Comparator#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		return obj instanceof GroupsComparator;
	}
}