/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.provisional.views;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;

/**
 * <p>
 * Provides actions from extensions for menu and {@see org.eclipse.ui.IActionBars}
 * &nbsp;contributions.
 * </p>
 * This interface is used by the <b>org.eclipse.wst.common.navigator.views.actionProvider </b>
 * extension point and also as the <i>actionProvider </a> attribute for the
 * <b>org.eclipse.wst.common.navigator.views.navigatorContent </b> extension point.
 * </p>
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public interface ICommonActionProvider {

	/**
	 * <p>
	 * Initialize the current ICommonActionProvider with the supplied information.
	 * </p>
	 * 
	 * @param aViewPart
	 *            The view part that the current ICommonActionProvider will be associated with
	 * @param aViewer
	 *            The StructuredViewer that the current ICommonActionProvider will be used to supply
	 *            menus and ActionBar actions for
	 * @param aContentService
	 *            The content service that the current ICommonActionProvider will be associated with
	 */
	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService);

	/**
	 * <p>
	 * Clean up any long-lived objects or resources. Do not dispose of any of the components
	 * supplied during {@see #init(IViewPart, StructuredViewer, NavigatorContentService)}.
	 * </p>
	 *  
	 */
	public void dispose();

	/**
	 * <p>
	 * The action context will be made available before any invocation of
	 * {@see #fillContextMenu(IMenuManager)}&nbsp; or {@see #fillActionBars(IActionBars)}. The
	 * action context contains the current selection in the viewer. Implementors should use that
	 * selection when computing their additions.
	 * </p>
	 * 
	 * @param aContext
	 *            An action context that contains the current selection in the viewer.
	 */
	public void setActionContext(ActionContext aContext);

	/**
	 * <p>
	 * Contribute menu actions to aMenu which are relevant to the selection supplied from
	 * {@see #setActionContext(ActionContext)}.
	 * </p>
	 * 
	 * @param aMenu
	 *            The menu from the viewer that requires contributions.
	 * @return True if anything was added to the menu
	 */
	public boolean fillContextMenu(IMenuManager aMenu);

	/**
	 * <p>
	 * Contribute the correct global, retargetable actions based on the selection supplied in
	 * {@see #setActionContext(ActionContext)}. Do not call {@see IActionBars#updateActionBars()}
	 * &nbsp; during this method. The action bars will be updated after all extensions have had a
	 * chance to contribute.
	 * </p>
	 * 
	 * @param theActionBars
	 *            The action bars associated with the current viewer
	 * @return True if anything was added to the action bars
	 */
	public boolean fillActionBars(IActionBars theActionBars);

	/**
	 * <p>
	 * Restore the previous state of any actions using the flags in aMemento. This method allows the
	 * state of any actions that persist from session to session to be restored.
	 * </p> 
	 * 
	 * @param aMemento
	 *            A memento that was given to the view part to restore its state.
	 */
	public void restoreState(IMemento aMemento);

	/**
	 * <p>
	 * Save flags in aMemento to remember the state of any actions that persist from session to
	 * session.
	 * </p>
	 * <p>
	 * Extensions should qualify any keys stored in the memento with their plugin id
	 * </p>
	 * 
	 * @param aMemento
	 *            A memento that was given to the view part to save its state.
	 */
	public void saveState(IMemento aMemento);

}
