/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.EMFExpression;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonActionProvider;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class CommonActionProviderDescriptor {

	private final IConfigurationElement configurationElement;
	private ActionExpression enablement;
	private static final String ENABLEMENT = "enablement"; //$NON-NLS-1$
	private boolean hasLoadingFailed;
	private static final String ATT_CLASS = "class"; //$NON-NLS-1$
	
	private static final String EMF_ENABLEMENT = "emfEnablement"; //$NON-NLS-1$
	private EMFExpression emfEnablement;

	/**
	 *  
	 */
	public CommonActionProviderDescriptor(IConfigurationElement aConfigElement) {
		super();
		configurationElement = aConfigElement;
		init();
	}

	/**
	 *  
	 */
	private void init() {

		IConfigurationElement[] children = configurationElement.getChildren(ENABLEMENT);
		if (children.length == 1) {
			enablement = new ActionExpression(children[0]);
		} else if (children.length > 1) {
			System.err.println("More than one element: " + //$NON-NLS-1$
						ENABLEMENT + " in navigator extension: " + //$NON-NLS-1$
						configurationElement.getDeclaringExtension().getUniqueIdentifier());
		}
		
		children = configurationElement.getChildren(EMF_ENABLEMENT);
		if (children.length == 1) {
			emfEnablement = new EMFExpression(children[0]);
		} else if (children.length > 1) {
			System.err.println("More than one element: " + //$NON-NLS-1$
						EMF_ENABLEMENT + " in navigator extension: " + //$NON-NLS-1$
						configurationElement.getDeclaringExtension().getUniqueIdentifier());
		}
	}

	public ICommonActionProvider createActionProvider() {
		if (hasLoadingFailed)
			return SkeletonActionProvider.INSTANCE;
		ICommonActionProvider provider = null;
		try {
			provider = (ICommonActionProvider) configurationElement.createExecutableExtension(ATT_CLASS);
		} catch (CoreException exception) {
			WorkbenchPlugin.log("Unable to create navigator extension: " + //$NON-NLS-1$
						getClassName(), exception.getStatus());
			hasLoadingFailed = true;
		} catch (Exception e) {
			WorkbenchPlugin.log("Unable to create navigator extension: " + //$NON-NLS-1$
						getClassName(), e);
			e.printStackTrace();
			hasLoadingFailed = true;
		}
		return provider;
	}

	/**
	 * @return
	 */
	private String getClassName() {
		return configurationElement.getAttribute(ATT_CLASS);
	}

	public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
		return (enablement != null && enablement.isEnabledFor(aStructuredSelection)) || (emfEnablement != null && emfEnablement.isEnabledFor(aStructuredSelection));
	}

	public boolean isEnabledFor(Object anElement) {
		return (enablement != null && enablement.isEnabledFor(anElement)) || (emfEnablement != null && emfEnablement.isEnabledFor(anElement));
	}

}
