/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.deferred;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;


/**
 * @author mdelder
 *  
 */
public class ProxyContentProvider implements INavigatorContentProvider {

	private ProxyContentExtension proxyContentExtension;
	private ProxyRoot root;
	private InputChangedCache inputCache;

	public ProxyContentProvider(ProxyContentExtension proxyContentExtension) {
		this.proxyContentExtension = proxyContentExtension;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		if (shouldProxy()) {
			// should be equal by reference if it came from this ProxyContentProvider
			if (parentElement == getRoot()) {
				new ProxyUpdateJob().schedule();
				return new Object[]{new ProxyPendingAdapter()};
			}
		}
		return getDelegateContentProvider().getChildren(parentElement);
	}

	protected class ProxyUpdateJob extends UIJob {

		public ProxyUpdateJob() {
			super(""); //$NON-NLS-1$
			setSystem(true);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.wst.common.navigator.views.UIJob#runInUIThread(org.eclipse.core.runtime.IProgressMonitor)
		 */
		public IStatus runInUIThread(IProgressMonitor monitor) {
			// TODO Handle update of proxy
			//			Object[] elements =
			// getDelegateContentProvider().getElements(getRoot().getInputElement());
			//			
			//			if (elements != null && elements.length == 1) {
			//				getTree().setRedraw(false);
			//				super.remove(proxy);
			//				super.internalRefresh(parent, true);
			//				getTree().setRedraw(true);
			//				getTree().redraw();
			//				setExpandedState(element, true);
			//			}
			//				getContainingExtension().getExtensionSite().updateProxy(getContainingExtension(),
			// getRoot(), getRoot().getInputElement(), elements[0]);
			return Status.OK_STATUS;
		}
	}

	/**
	 * @return
	 */
	private ProxyRoot getRoot(Object inputElement) {
		if (getRoot().getInputElement() != inputElement)
			getRoot().setInputElement(inputElement);
		return root;
	}

	/**
	 * @return
	 */
	private ProxyRoot getRoot() {
		if (root == null)
			root = new ProxyRoot(getProxyContentExtension().getDescriptor().getName(), getProxyContentExtension().getDescriptor().getId());
		return root;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		if (element == getRoot())
			return null;
		return getDelegateContentProvider().getParent(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		if (element instanceof ProxyPendingAdapter)
			return false;
		else if (shouldProxy())
			return true;
		return getDelegateContentProvider().hasChildren(element);
	}

	/**
	 * Forces the load of the delegate content provider if necessary
	 * 
	 * @return
	 */
	private INavigatorContentProvider getDelegateContentProvider() {
		return getDelegateContentProvider(true);
	}

	/**
	 * Forces the load of the delegate content provider if necessary
	 * 
	 * @return
	 */
	private INavigatorContentProvider getDelegateContentProvider(boolean applyInputCache) {
		INavigatorContentProvider localDelegateContentProvider = getProxyContentExtension().getDelegateContentProvider();
		if (applyInputCache && inputCache != null && !shouldProxy()) {
			localDelegateContentProvider.inputChanged(inputCache.viewer, inputCache.oldValue, inputCache.newValue);
			inputCache = null;
		}
		return localDelegateContentProvider;
	}

	/**
	 * @return
	 */
	protected boolean shouldProxy() {
		return !getProxyContentExtension().isContentProviderLoaded();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		if (shouldProxy())
			return new Object[]{getRoot(inputElement)};
		return getDelegateContentProvider().getElements(inputElement);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (shouldProxy())
			inputCache = new InputChangedCache(viewer, oldInput, newInput);
		else
			getDelegateContentProvider(false).inputChanged(viewer, oldInput, newInput);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentProvider#getContainingExtension()
	 */
	public INavigatorContentExtension getContainingExtension() {
		return getProxyContentExtension();
	}

	public class InputChangedCache {

		public final Viewer viewer;

		public final Object oldValue;

		public final Object newValue;

		public InputChangedCache(Viewer viewer, Object oldValue, Object newValue) {
			this.viewer = viewer;
			this.oldValue = oldValue;
			this.newValue = newValue;
		}
	}

	protected ProxyContentExtension getProxyContentExtension() {
		return proxyContentExtension;
	}
}
