/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonOpenListener;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class CommonOpenService implements IOpenListener, INavigatorContentServiceListener {


	private NavigatorContentService contentService;
	private CommonNavigator commonNavigator;

	/**
	 * @param aCommonNavigator
	 * @param commonNavigatorId
	 * @param viewer
	 * @param contentService
	 */
	public CommonOpenService(NavigatorContentService aContentService, CommonNavigator aCommonNavigator) {
		contentService = aContentService;
		commonNavigator = aCommonNavigator;
		init();
	}

	/**
	 *  
	 */
	private void init() {
		contentService.addListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IOpenListener#open(org.eclipse.jface.viewers.OpenEvent)
	 */
	public void open(OpenEvent anEvent) {
		ISelection selection = anEvent.getSelection();
		if (selection instanceof IStructuredSelection) {
			NavigatorContentDescriptorInstance[] contentDescriptorInstances = contentService.findRelevantContentDescriptorInstances((IStructuredSelection) selection);
			NavigatorContentDescriptorInstance contentDescriptorInstance = null;
			for (int x = 0; x < contentDescriptorInstances.length; ++x) {
				contentDescriptorInstance = contentDescriptorInstances[x];				
				contentDescriptorInstance.getOpenListener().open(anEvent);
			}
		}
	}

	/**
	 *  
	 */
	public void dispose() {
		contentService.removeListener(this);
	}

	public void onLoad(NavigatorContentDescriptorInstance aDescriptorInstance) {
		try {
			initialize(aDescriptorInstance.getOpenListener());
		} catch(RuntimeException re) {
			re.printStackTrace();
		}
	}

	/**
	 * @param openListener
	 */
	private void initialize(ICommonOpenListener anOpenListener) {
		if (anOpenListener != null && anOpenListener != SkeletonOpenListener.INSTANCE) {
			anOpenListener.initialize(commonNavigator, contentService);
		}
	}
}
