/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;

/**
 * A strategy to read navigator extensions from the registry.
 */
public class NavigatorRegistryReader extends RegistryReader {
	private static final String TAG_NAVIGATOR_CONTENT = "navigatorContent"; //$NON-NLS-1$
	private static final String TAG_NAVIGATOR_VIEW = "navigatorViewer"; //$NON-NLS-1$
	private static final String PL_NAVIGATOR_CONTENT = "navigatorContent"; //$NON-NLS-1$
	private static final String PL_NAVIGATOR_VIEW = "navigatorViewer"; //$NON-NLS-1$

	private NavigatorRegistry registry;

	/**
	 * Reads navigatorContent and navigatorViewer elements.
	 * 
	 * @see org.eclipse.ui.internal.registry.RegistryReader#readElement(org.eclipse.core.runtime.IConfigurationElement)
	 */
	protected boolean readElement(IConfigurationElement element) {
		if (element.getName().equals(TAG_NAVIGATOR_CONTENT)) {
			try {
				NavigatorContentDescriptor desc = new NavigatorContentDescriptor(element);
				registry.add(desc);
			} catch (WorkbenchException e) {
				// log an error since its not safe to open a dialog here
				NavigatorPlugin.log("Unable to create navigator descriptor.", e.getStatus());//$NON-NLS-1$
			}
			return true;
		} else if (element.getName().equals(TAG_NAVIGATOR_VIEW)) {
			try {
				NavigatorViewerDescriptor desc = new NavigatorViewerDescriptor(element);
				registry.add(desc);
				return true;
			} catch (WorkbenchException e) {
				// log an error since its not safe to open a dialog here
				NavigatorPlugin.log("Unable to create navigator view descriptor.", e.getStatus());//$NON-NLS-1$
			}
		}
		return false;
	}

	/**
	 * Reads the navigatorActions, navigatorContent and navigatorViewer extensions.
	 * 
	 * @param in
	 *            the plugin registry to read from
	 * @param out
	 *            the registry to store objects parsed from XML in
	 */
	public void readRegistry(IExtensionRegistry in, NavigatorRegistry out) {
		registry = out;
		readRegistry(in, NavigatorPlugin.PLUGIN_ID, PL_NAVIGATOR_CONTENT); //$NON-NLS-1$
		readRegistry(in, NavigatorPlugin.PLUGIN_ID, PL_NAVIGATOR_VIEW); //$NON-NLS-1$		
	}
}
