/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Feb 9, 2004
 *
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;

/**
 * 
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 *  
 */
public class SelectFiltersAction extends Action implements IAction {

	private final CommonViewer commonViewer;

	public SelectFiltersAction(CommonViewer aViewer) {
		super(NavigatorMessages.SelectFiltersActionDelegate_0); //$NON-NLS-1$
		setToolTipText(NavigatorMessages.SelectFiltersActionDelegate_1); //$NON-NLS-1$
		commonViewer = aViewer;
	}

	public void run() {
		CommonFilterSelectionDialog filterSelectionDialog = new CommonFilterSelectionDialog(commonViewer.getTree().getShell(), commonViewer);
		filterSelectionDialog.open();
	}

}
