/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.ExceptionCollector;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class CVSLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IResourceStateChangeListener,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.team.cvs.ui.decorator";
    private static ExceptionCollector exceptions = new ExceptionCollector(CVSUIMessages.CVSDecorator_exceptionMessage, "org.eclipse.team.cvs.ui", 4, CVSUIPlugin.getPlugin().getLog());
    private static String DECORATOR_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static SimpleDateFormat decorateFormatter = new SimpleDateFormat(DECORATOR_FORMAT, Locale.getDefault());
    private static String[] fonts = new String[]{"org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_font", "org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_font"};
    private static String[] colors = new String[]{"org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_background_color", "org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_foreground_color", "org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_background_color", "org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_foreground_color"};
    static /* synthetic */ Class class$0;

    public CVSLightweightDecorator() {
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener((IResourceStateChangeListener)this);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        CVSUIPlugin.addPropertyChangeListener(this);
        this.ensureFontAndColorsCreated(fonts, colors);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
        CVSProviderPlugin.broadcastDecoratorEnablementChanged((boolean)true);
    }

    private void ensureFontAndColorsCreated(final String[] fonts, final String[] colors) {
        CVSUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                int i = 0;
                while (i < colors.length) {
                    theme.getColorRegistry().get(colors[i]);
                    ++i;
                }
                i = 0;
                while (i < fonts.length) {
                    theme.getFontRegistry().get(fonts[i]);
                    ++i;
                }
            }
        });
    }

    public static boolean isDirty(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isIgnored() && cvsResource.isModified(null);
    }

    public static boolean isDirty(IResource resource) {
        if (!resource.exists()) {
            return false;
        }
        try {
            return CVSLightweightDecorator.isDirty(CVSWorkspaceRoot.getCVSResourceFor((IResource)resource));
        }
        catch (CVSException e) {
            boolean accessible = resource.getProject().isAccessible();
            if (accessible) {
                CVSLightweightDecorator.handleException((CoreException)((Object)e));
            }
            return accessible;
        }
    }

    private CVSTeamProvider getCVSProviderFor(IResource resource) {
        RepositoryProvider p = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
        if (p == null) {
            return null;
        }
        return (CVSTeamProvider)p;
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public void decorate(Object element, IDecoration decoration) {
        block5: {
            IResource resource = this.getResource(element);
            if (resource == null || resource.getType() == 8) {
                return;
            }
            CVSTeamProvider cvsProvider = this.getCVSProviderFor(resource);
            if (cvsProvider == null) {
                return;
            }
            try {
                CVSDecoration cvsDecoration = CVSLightweightDecorator.decorate(resource, true);
                cvsDecoration.setWatchEditEnabled(cvsProvider.isWatchEditEnabled());
                cvsDecoration.apply(decoration);
            }
            catch (CVSException e) {
                CVSLightweightDecorator.handleException((CoreException)((Object)e));
            }
            catch (IllegalStateException e) {
                if (Platform.getBundle((String)"org.eclipse.team.cvs.ui").getState() != 32) break block5;
                throw e;
            }
        }
    }

    public static CVSDecoration decorate(IResource resource, boolean includeDirtyCheck) throws CVSException {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        CVSDecoration cvsDecoration = new CVSDecoration(resource.getName());
        cvsDecoration.setResourceType(resource.getType());
        if (cvsResource.isIgnored()) {
            cvsDecoration.setIgnored(true);
        }
        if (!cvsDecoration.isIgnored()) {
            CVSTag tag;
            if (includeDirtyCheck) {
                boolean computeDeepDirtyCheck = store.getBoolean("pref_calculate_dirty");
                int type = resource.getType();
                if (type == 1 || computeDeepDirtyCheck) {
                    cvsDecoration.setDirty(CVSLightweightDecorator.isDirty(resource));
                }
            }
            if ((tag = CVSLightweightDecorator.getTagToShow(resource)) != null) {
                Date date;
                String name = tag.getName();
                if (tag.getType() == 3 && (date = tag.asDate()) != null) {
                    name = decorateFormatter.format(date);
                }
                cvsDecoration.setTag(name);
            }
            cvsDecoration.setHasRemote(CVSWorkspaceRoot.hasRemote((IResource)resource));
            if (store.getBoolean("pref_show_newresource") && cvsResource.exists()) {
                if (cvsResource.isFolder()) {
                    if (!((ICVSFolder)cvsResource).isCVSFolder()) {
                        cvsDecoration.setNewResource(true);
                    }
                } else if (!cvsResource.isManaged()) {
                    cvsDecoration.setNewResource(true);
                }
            }
        }
        if (resource.getType() == 1) {
            CVSLightweightDecorator.extractFileProperties((IFile)resource, cvsDecoration);
        } else {
            CVSLightweightDecorator.extractContainerProperties((IContainer)resource, cvsDecoration);
        }
        return cvsDecoration;
    }

    private static void extractContainerProperties(IContainer resource, CVSDecoration cvsDecoration) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
        FolderSyncInfo folderInfo = folder.getFolderSyncInfo();
        if (folderInfo != null) {
            cvsDecoration.setLocation(KnownRepositories.getInstance().getRepository(folderInfo.getRoot()));
            cvsDecoration.setRepository(folderInfo.getRepository());
            cvsDecoration.setVirtualFolder(folderInfo.isVirtualDirectory());
        }
    }

    private static void extractFileProperties(IFile resource, CVSDecoration cvsDecoration) throws CVSException {
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
        ResourceSyncInfo fileInfo = file.getSyncInfo();
        Command.KSubstOption option = Command.KSubstOption.fromFile((IFile)resource);
        if (fileInfo != null) {
            cvsDecoration.setAdded(fileInfo.isAdded());
            cvsDecoration.setRevision(fileInfo.getRevision());
            cvsDecoration.setReadOnly(file.isReadOnly());
            cvsDecoration.setNeedsMerge(fileInfo.isNeedsMerge(file.getTimeStamp()));
            option = fileInfo.getKeywordMode();
        }
        cvsDecoration.setKeywordSubstitution(option.getShortDisplayText());
    }

    protected static CVSTag getTagToShow(IResource resource) throws CVSException {
        FolderSyncInfo parentInfo;
        ICVSFolder parent;
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        CVSEntryLineTag tag = null;
        boolean managed = false;
        if (cvsResource.isFolder()) {
            FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
            if (folderInfo != null) {
                tag = folderInfo.getTag();
                managed = true;
            }
        } else {
            ResourceSyncInfo info = ((ICVSFile)cvsResource).getSyncInfo();
            if (info != null) {
                tag = info.getTag();
                managed = true;
            }
        }
        if ((parent = cvsResource.getParent()) != null && managed && (parentInfo = parent.getFolderSyncInfo()) != null) {
            CVSEntryLineTag parentTag = parentInfo.getTag();
            parentTag = parentTag == null ? CVSTag.DEFAULT : parentTag;
            Object object = tag = tag == null ? CVSTag.DEFAULT : tag;
            if (parentTag.getName().equals(tag.getName())) {
                tag = null;
            }
        }
        return tag;
    }

    private void addWithParents(IResource resource, Set resources) {
        IResource current = resource;
        while (current.getType() != 8) {
            resources.add(current);
            current = current.getParent();
        }
    }

    public static void refresh() {
        CVSUIPlugin.getPlugin().getWorkbench().getDecoratorManager().update(ID);
    }

    public void refresh(IProject project) {
        final ArrayList resources = new ArrayList();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    resources.add(resource);
                    return true;
                }
            });
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
        }
        catch (CoreException e) {
            CVSLightweightDecorator.handleException(e);
        }
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void externalSyncInfoChange(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceModified(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceStateChanged(IResource[] changedResources) {
        HashSet<IResource> resourcesToUpdate = new HashSet<IResource>();
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        boolean showingDeepDirtyIndicators = store.getBoolean("pref_calculate_dirty");
        int i = 0;
        while (i < changedResources.length) {
            IResource resource = changedResources[i];
            if (showingDeepDirtyIndicators) {
                this.addWithParents(resource, resourcesToUpdate);
            } else {
                resourcesToUpdate.add(resource);
            }
            ++i;
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resourcesToUpdate.toArray()));
    }

    public void projectConfigured(IProject project) {
        this.refresh(project);
    }

    public void projectDeconfigured(IProject project) {
        this.refresh(project);
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CVSLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener((IPropertyChangeListener)this);
        CVSProviderPlugin.broadcastDecoratorEnablementChanged((boolean)false);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        CVSUIPlugin.removePropertyChangeListener(this);
    }

    private static void handleException(CoreException e) {
        exceptions.handleException(e);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isEventOfInterest(event)) {
            this.ensureFontAndColorsCreated(fonts, colors);
            CVSLightweightDecorator.refresh();
        }
    }

    private boolean isEventOfInterest(PropertyChangeEvent event) {
        String prop = event.getProperty();
        return prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed") || prop.equals("org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_background_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_foreground_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_font") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_foreground_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_background_color") || prop.equals("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_font");
    }
}

