/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Annotate;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AnnotateListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AnnotateView;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ShowAnnotationOperation
extends CVSOperation {
    private final ICVSResource fCVSResource;
    private final String fRevision;
    private final boolean binary;

    public ShowAnnotationOperation(IWorkbenchPart part, ICVSResource cvsResource, String revision, boolean binary) {
        super(part);
        this.fCVSResource = cvsResource;
        this.fRevision = revision;
        this.binary = binary;
    }

    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 100);
        final AnnotateListener listener = new AnnotateListener();
        this.fetchAnnotation(listener, this.fCVSResource, this.fRevision, Policy.subMonitorFor(monitor, 80));
        try {
            if (this.hasCharset(this.fCVSResource, listener.getContents())) {
                listener.setContents(this.getRemoteContents(this.fCVSResource, Policy.subMonitorFor(monitor, 20)));
            }
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
        Display display = this.getPart().getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ShowAnnotationOperation.this.showView(listener);
            }
        });
        monitor.done();
    }

    protected String getTaskName() {
        return CVSUIMessages.ShowAnnotationOperation_taskName;
    }

    protected boolean hasCharset(ICVSResource cvsResource, InputStream contents) {
        try {
            return TeamPlugin.getCharset((String)cvsResource.getName(), (InputStream)contents) != null;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void showView(AnnotateListener listener) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        String defaultPerspectiveID = this.promptForPerspectiveSwitch();
        if (defaultPerspectiveID != null) {
            try {
                workbench.showPerspective(defaultPerspectiveID, window);
            }
            catch (WorkbenchException e) {
                Utils.handleError((Shell)window.getShell(), (Exception)((Object)e), (String)CVSUIMessages.ShowAnnotationOperation_0, (String)e.getMessage());
            }
        }
        try {
            AnnotateView view = AnnotateView.openInActivePerspective();
            view.showAnnotations(this.fCVSResource, listener.getCvsAnnotateBlocks(), listener.getContents());
        }
        catch (PartInitException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAnnotation(AnnotateListener listener, ICVSResource cvsResource, String revision, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        ICVSFolder folder = cvsResource.getParent();
        FolderSyncInfo info = folder.getFolderSyncInfo();
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
        Session session = new Session(location, folder, true);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
            try {
                IStatus status;
                CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                ArrayList<Object> localOptions = new ArrayList<Object>();
                if (revision != null) {
                    localOptions.add(Annotate.makeRevisionOption((String)revision));
                }
                if (this.binary) {
                    localOptions.add(Annotate.FORCE_BINARY_ANNOTATE);
                }
                if ((status = Command.ANNOTATE.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{cvsResource}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90))).getCode() == -10) {
                    throw new CVSServerException(status);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
                throw throwable;
            }
            {
                Object var12_14 = null;
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            session.close();
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        session.close();
    }

    private InputStream getRemoteContents(ICVSResource resource, IProgressMonitor monitor) throws CoreException {
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)resource);
        if (remote == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        IStorage storage = ((IResourceVariant)remote).getStorage(monitor);
        if (storage == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return storage.getContents();
    }

    private String promptForPerspectiveSwitch() {
        IPerspectiveDescriptor current;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_change_perspective_on_show_annotations");
        String desiredID = store.getString("pref_default_perspective_for_show_annotations");
        if (option.equals("always")) {
            return desiredID;
        }
        if (option.equals("never")) {
            return null;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor desired = registry.findPerspectiveWithId(desiredID);
        IWorkbenchPage page = CVSUIPlugin.getActivePage();
        if (page != null && (current = page.getPerspective()) != null && current.getId().equals(desiredID)) {
            return null;
        }
        if (desired != null) {
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)CVSUIMessages.ShowAnnotationOperation_1, (String)NLS.bind((String)CVSUIMessages.ShowAnnotationOperation_2, (Object[])new String[]{desired.getLabel()}), (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_change_perspective_on_show_annotations");
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return desiredID;
                }
                case 3: {
                    return null;
                }
            }
        }
        return null;
    }
}

